/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.cli.debug;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Objects;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.SparkSession;
import org.locationtech.geowave.analytic.spark.GeoWaveRDDLoader;
import org.locationtech.geowave.analytic.spark.GeoWaveSparkConf;
import org.locationtech.geowave.analytic.spark.RDDOptions;
import org.locationtech.geowave.analytic.spark.spatial.SpatialJoinRunner;
import org.locationtech.geowave.cli.debug.AbstractGeoWaveQuery;
import org.locationtech.geowave.cli.debug.DebugSection;
import org.locationtech.geowave.core.cli.annotations.GeowaveOperation;
import org.locationtech.geowave.core.geotime.store.GeotoolsFeatureDataAdapter;
import org.locationtech.geowave.core.geotime.store.query.api.VectorQueryBuilder;
import org.locationtech.geowave.core.store.api.DataStore;
import org.locationtech.geowave.core.store.api.Query;
import org.locationtech.geowave.core.store.cli.store.DataStorePluginOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GeowaveOperation(name={"sparkcql"}, parentOperation=DebugSection.class)
@Parameters(commandDescription="spark cql query")
public class SparkQuery
extends AbstractGeoWaveQuery {
    private static Logger LOGGER = LoggerFactory.getLogger(SparkQuery.class);
    @Parameter(names={"--cql"}, required=true, description="CQL Filter executed client side")
    private String cqlStr;
    @Parameter(names={"--sparkMaster"}, description="Spark Master")
    private String sparkMaster = "yarn";
    @Parameter(names={"-n", "--name"}, description="The spark application name")
    private String appName = "Spatial Join Spark";
    @Parameter(names={"-ho", "--host"}, description="The spark driver host")
    private String host = "localhost";

    @Override
    protected long runQuery(GeotoolsFeatureDataAdapter adapter, String typeName, String indexName, DataStore dataStore, boolean debug, DataStorePluginOptions pluginOptions) {
        String jar = "";
        try {
            jar = SpatialJoinRunner.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
        }
        catch (URISyntaxException e) {
            LOGGER.error("Unable to set jar location in spark configuration", (Throwable)e);
        }
        SparkConf addonOptions = GeoWaveSparkConf.getDefaultConfig();
        addonOptions = addonOptions.setAppName(this.appName).setMaster(this.sparkMaster).set("spark.jars", jar);
        if (!Objects.equals(this.sparkMaster, "yarn")) {
            addonOptions = addonOptions.set("spark.driver.host", this.host);
        }
        SparkSession session = GeoWaveSparkConf.createDefaultSession((SparkConf)addonOptions);
        long count = 0L;
        VectorQueryBuilder bldr = VectorQueryBuilder.newBuilder();
        if (typeName != null) {
            bldr.addTypeName(typeName);
        }
        if (indexName != null) {
            bldr.indexName(indexName);
        }
        RDDOptions rddOptions = new RDDOptions();
        rddOptions.setQuery((Query)((VectorQueryBuilder)bldr.constraints(bldr.constraintsFactory().cqlConstraints(this.cqlStr))).build());
        try {
            count = GeoWaveRDDLoader.loadRDD((SparkContext)session.sparkContext(), (DataStorePluginOptions)pluginOptions, (RDDOptions)rddOptions).getRawRDD().count();
        }
        catch (IOException e) {
            LOGGER.warn("Unable to load RDD", (Throwable)e);
        }
        return count;
    }
}

