/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.cli.debug;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import org.locationtech.geowave.cli.debug.AbstractGeoWaveQuery;
import org.locationtech.geowave.cli.debug.DebugSection;
import org.locationtech.geowave.core.cli.annotations.GeowaveOperation;
import org.locationtech.geowave.core.geotime.store.GeotoolsFeatureDataAdapter;
import org.locationtech.geowave.core.geotime.store.query.api.VectorAggregationQueryBuilder;
import org.locationtech.geowave.core.geotime.store.query.api.VectorQueryBuilder;
import org.locationtech.geowave.core.store.CloseableIterator;
import org.locationtech.geowave.core.store.api.AggregationQuery;
import org.locationtech.geowave.core.store.api.DataStore;
import org.locationtech.geowave.core.store.api.Query;
import org.locationtech.geowave.core.store.cli.store.DataStorePluginOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GeowaveOperation(name={"serverCql"}, parentOperation=DebugSection.class)
@Parameters(commandDescription="cql server-side")
public class CQLQuery
extends AbstractGeoWaveQuery {
    private static Logger LOGGER = LoggerFactory.getLogger(CQLQuery.class);
    @Parameter(names={"--cql"}, required=true, description="CQL Filter executed client side")
    private String cqlStr;
    @Parameter(names={"--useAggregation", "-agg"}, description="Compute count on the server side")
    private Boolean useAggregation = Boolean.FALSE;

    @Override
    protected long runQuery(GeotoolsFeatureDataAdapter adapter, String typeName, String indexName, DataStore dataStore, boolean debug, DataStorePluginOptions pluginOptions) {
        long count = 0L;
        if (this.useAggregation.booleanValue()) {
            VectorAggregationQueryBuilder bldr = (VectorAggregationQueryBuilder)((VectorAggregationQueryBuilder)VectorAggregationQueryBuilder.newBuilder().count(new String[]{typeName})).indexName(indexName);
            Long countResult = (Long)dataStore.aggregate((AggregationQuery)((VectorAggregationQueryBuilder)bldr.constraints(bldr.constraintsFactory().cqlConstraints(this.cqlStr))).build());
            if (countResult != null) {
                count += countResult.longValue();
            }
            return count;
        }
        VectorQueryBuilder bldr = (VectorQueryBuilder)((VectorQueryBuilder)VectorQueryBuilder.newBuilder().addTypeName(typeName)).indexName(indexName);
        try (CloseableIterator it = dataStore.query((Query)((VectorQueryBuilder)bldr.constraints(bldr.constraintsFactory().cqlConstraints(this.cqlStr))).build());){
            while (it.hasNext()) {
                if (debug) {
                    System.out.println(it.next());
                } else {
                    it.next();
                }
                ++count;
            }
        }
        return count;
    }
}

