/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.cli.debug;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import org.apache.commons.lang3.time.StopWatch;
import org.locationtech.geowave.cli.debug.AbstractGeoWaveQuery;
import org.locationtech.geowave.cli.debug.DebugSection;
import org.locationtech.geowave.core.cli.annotations.GeowaveOperation;
import org.locationtech.geowave.core.geotime.store.GeotoolsFeatureDataAdapter;
import org.locationtech.geowave.core.geotime.store.query.api.VectorAggregationQueryBuilder;
import org.locationtech.geowave.core.geotime.store.query.api.VectorQueryBuilder;
import org.locationtech.geowave.core.store.CloseableIterator;
import org.locationtech.geowave.core.store.api.AggregationQuery;
import org.locationtech.geowave.core.store.api.DataStore;
import org.locationtech.geowave.core.store.api.Query;
import org.locationtech.geowave.core.store.cli.store.DataStorePluginOptions;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GeowaveOperation(name={"bbox"}, parentOperation=DebugSection.class)
@Parameters(commandDescription="bbox query")
public class BBOXQuery
extends AbstractGeoWaveQuery {
    private static Logger LOGGER = LoggerFactory.getLogger(BBOXQuery.class);
    @Parameter(names={"-e", "--east"}, required=true, description="Max Longitude of BBOX")
    private Double east;
    @Parameter(names={"-w", "--west"}, required=true, description="Min Longitude of BBOX")
    private Double west;
    @Parameter(names={"-n", "--north"}, required=true, description="Max Latitude of BBOX")
    private Double north;
    @Parameter(names={"-s", "--south"}, required=true, description="Min Latitude of BBOX")
    private Double south;
    @Parameter(names={"--useAggregation", "-agg"}, description="Compute count on the server side")
    private Boolean useAggregation = Boolean.FALSE;
    private Geometry geom;

    private void getBoxGeom() {
        this.geom = new GeometryFactory().toGeometry(new Envelope(this.west.doubleValue(), this.east.doubleValue(), this.south.doubleValue(), this.north.doubleValue()));
    }

    @Override
    protected long runQuery(GeotoolsFeatureDataAdapter adapter, String typeName, String indexName, DataStore dataStore, boolean debug, DataStorePluginOptions pluginOptions) {
        StopWatch stopWatch = new StopWatch();
        this.getBoxGeom();
        long count = 0L;
        if (this.useAggregation.booleanValue()) {
            VectorAggregationQueryBuilder bldr = (VectorAggregationQueryBuilder)((VectorAggregationQueryBuilder)VectorAggregationQueryBuilder.newBuilder().count(new String[]{typeName})).indexName(indexName);
            Long countResult = (Long)dataStore.aggregate((AggregationQuery)((VectorAggregationQueryBuilder)bldr.constraints(bldr.constraintsFactory().spatialTemporalConstraints().spatialConstraints(this.geom).build())).build());
            if (countResult != null) {
                count += countResult.longValue();
            }
        } else {
            VectorQueryBuilder bldr = (VectorQueryBuilder)((VectorQueryBuilder)VectorQueryBuilder.newBuilder().addTypeName(typeName)).indexName(indexName);
            stopWatch.start();
            try (CloseableIterator it = dataStore.query((Query)((VectorQueryBuilder)bldr.constraints(bldr.constraintsFactory().spatialTemporalConstraints().spatialConstraints(this.geom).build())).build());){
                stopWatch.stop();
                System.out.println("Ran BBOX query in " + stopWatch.toString());
                stopWatch.reset();
                stopWatch.start();
                while (it.hasNext()) {
                    if (debug) {
                        System.out.println(it.next());
                    } else {
                        it.next();
                    }
                    ++count;
                }
                stopWatch.stop();
                System.out.println("BBOX query results iteration took " + stopWatch.toString());
            }
        }
        return count;
    }
}

