/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.cli.debug;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.time.StopWatch;
import org.locationtech.geowave.core.cli.api.Command;
import org.locationtech.geowave.core.cli.api.DefaultOperation;
import org.locationtech.geowave.core.cli.api.OperationParams;
import org.locationtech.geowave.core.cli.converters.GeoWaveBaseConverter;
import org.locationtech.geowave.core.geotime.store.GeotoolsFeatureDataAdapter;
import org.locationtech.geowave.core.index.ByteArray;
import org.locationtech.geowave.core.store.CloseableIterator;
import org.locationtech.geowave.core.store.adapter.InternalDataAdapter;
import org.locationtech.geowave.core.store.adapter.PersistentAdapterStore;
import org.locationtech.geowave.core.store.api.DataStore;
import org.locationtech.geowave.core.store.cli.store.DataStorePluginOptions;
import org.locationtech.geowave.core.store.cli.store.StoreLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGeoWaveQuery
extends DefaultOperation
implements Command {
    private static Logger LOGGER = LoggerFactory.getLogger(AbstractGeoWaveQuery.class);
    @Parameter(description="<storename>")
    private List<String> parameters = new ArrayList<String>();
    @Parameter(names={"--indexName"}, description="The name of the index (optional)")
    private String indexName;
    @Parameter(names={"--typeName"}, description="Optional ability to provide an adapter type name")
    private String typeName;
    @Parameter(names={"--debug"}, description="Print out additional info for debug purposes")
    private boolean debug = false;

    public void setParameters(List<String> parameters) {
        this.parameters = parameters;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void execute(OperationParams params) throws ParseException {
        GeotoolsFeatureDataAdapter adapter;
        StopWatch stopWatch = new StopWatch();
        if (this.parameters.size() != 1) {
            throw new ParameterException("Requires arguments: <storename>");
        }
        String storeName = this.parameters.get(0);
        StoreLoader storeOptions = new StoreLoader(storeName);
        if (!storeOptions.loadFromConfig(this.getGeoWaveConfigFile(params), params.getConsole())) {
            throw new ParameterException("Cannot find store name: " + storeOptions.getStoreName());
        }
        DataStore dataStore = storeOptions.createDataStore();
        PersistentAdapterStore adapterStore = storeOptions.createAdapterStore();
        if (this.typeName != null) {
            adapter = (GeotoolsFeatureDataAdapter)((InternalDataAdapter)adapterStore.getAdapter((Object)storeOptions.createInternalAdapterStore().getAdapterId(this.typeName))).getAdapter();
        } else {
            CloseableIterator it = adapterStore.getAdapters();
            adapter = (GeotoolsFeatureDataAdapter)((InternalDataAdapter)it.next()).getAdapter();
            it.close();
        }
        if (this.debug && adapter != null) {
            System.out.println(adapter);
        }
        stopWatch.start();
        long results = this.runQuery(adapter, this.typeName, this.indexName, dataStore, this.debug, storeOptions.getDataStorePlugin());
        stopWatch.stop();
        System.out.println("Got " + results + " results in " + stopWatch.toString());
    }

    protected abstract long runQuery(GeotoolsFeatureDataAdapter var1, String var2, String var3, DataStore var4, boolean var5, DataStorePluginOptions var6);

    public static class StringToByteArrayConverter
    extends GeoWaveBaseConverter<ByteArray> {
        public StringToByteArrayConverter(String optionName) {
            super(optionName);
        }

        public ByteArray convert(String value) {
            return new ByteArray(value);
        }
    }
}

