/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.cli.debug;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Range;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.time.StopWatch;
import org.locationtech.geowave.cli.debug.DebugSection;
import org.locationtech.geowave.core.cli.annotations.GeowaveOperation;
import org.locationtech.geowave.core.cli.api.Command;
import org.locationtech.geowave.core.cli.api.DefaultOperation;
import org.locationtech.geowave.core.cli.api.OperationParams;
import org.locationtech.geowave.core.store.cli.store.StoreLoader;
import org.locationtech.geowave.datastore.accumulo.config.AccumuloOptions;
import org.locationtech.geowave.datastore.accumulo.config.AccumuloRequiredOptions;
import org.locationtech.geowave.datastore.accumulo.operations.AccumuloOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GeowaveOperation(name={"fullscanMinimal"}, parentOperation=DebugSection.class)
@Parameters(commandDescription="full table scan without any iterators or deserialization")
public class MinimalFullTable
extends DefaultOperation
implements Command {
    private static Logger LOGGER = LoggerFactory.getLogger(MinimalFullTable.class);
    @Parameter(description="<storename>")
    private List<String> parameters = new ArrayList<String>();
    @Parameter(names={"--indexId"}, required=true, description="The name of the index (optional)")
    private String indexId;

    public void execute(OperationParams params) throws ParseException {
        StopWatch stopWatch = new StopWatch();
        if (this.parameters.size() != 1) {
            throw new ParameterException("Requires arguments: <storename>");
        }
        String storeName = this.parameters.get(0);
        StoreLoader storeOptions = new StoreLoader(storeName);
        if (!storeOptions.loadFromConfig(this.getGeoWaveConfigFile(params))) {
            throw new ParameterException("Cannot find store name: " + storeOptions.getStoreName());
        }
        String storeType = storeOptions.getDataStorePlugin().getType();
        if (storeType.equals("accumulo")) {
            try {
                AccumuloRequiredOptions opts = (AccumuloRequiredOptions)storeOptions.getFactoryOptions();
                AccumuloOperations ops = new AccumuloOperations(opts.getZookeeper(), opts.getInstance(), opts.getUser(), opts.getPassword(), opts.getGeoWaveNamespace(), (AccumuloOptions)opts.getStoreOptions());
                long results = 0L;
                BatchScanner scanner = ops.createBatchScanner(this.indexId, new String[0]);
                scanner.setRanges(Collections.singleton(new Range()));
                Iterator it = scanner.iterator();
                stopWatch.start();
                while (it.hasNext()) {
                    it.next();
                    ++results;
                }
                stopWatch.stop();
                scanner.close();
                System.out.println("Got " + results + " results in " + stopWatch.toString());
            }
            catch (AccumuloException | AccumuloSecurityException | TableNotFoundException e) {
                LOGGER.error("Unable to scan accumulo datastore", e);
            }
        } else {
            if (storeType.equals("hbase")) {
                throw new UnsupportedOperationException("full scan for store type " + storeType + " not yet implemented.");
            }
            throw new UnsupportedOperationException("full scan for store type " + storeType + " not implemented.");
        }
    }
}

