/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.cli.debug;

import com.beust.jcommander.Parameters;
import org.locationtech.geowave.cli.debug.AbstractGeoWaveQuery;
import org.locationtech.geowave.cli.debug.DebugSection;
import org.locationtech.geowave.core.cli.annotations.GeowaveOperation;
import org.locationtech.geowave.core.geotime.store.GeotoolsFeatureDataAdapter;
import org.locationtech.geowave.core.store.CloseableIterator;
import org.locationtech.geowave.core.store.api.DataStore;
import org.locationtech.geowave.core.store.api.Query;
import org.locationtech.geowave.core.store.api.QueryBuilder;
import org.locationtech.geowave.core.store.cli.store.DataStorePluginOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GeowaveOperation(name={"fullscan"}, parentOperation=DebugSection.class)
@Parameters(commandDescription="fulltable scan")
public class FullTableScan
extends AbstractGeoWaveQuery {
    private static Logger LOGGER = LoggerFactory.getLogger(FullTableScan.class);

    @Override
    protected long runQuery(GeotoolsFeatureDataAdapter adapter, String typeName, String indexName, DataStore dataStore, boolean debug, DataStorePluginOptions pluginOptions) {
        long count = 0L;
        try (CloseableIterator it = dataStore.query((Query)((QueryBuilder)QueryBuilder.newBuilder().addTypeName(typeName).indexName(indexName)).build());){
            while (it.hasNext()) {
                if (debug) {
                    System.out.println(it.next());
                } else {
                    it.next();
                }
                ++count;
            }
        }
        return count;
    }
}

