/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.cli.debug;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.locationtech.geowave.cli.debug.AbstractGeoWaveQuery;
import org.locationtech.geowave.cli.debug.DebugSection;
import org.locationtech.geowave.core.cli.annotations.GeowaveOperation;
import org.locationtech.geowave.core.geotime.store.GeotoolsFeatureDataAdapter;
import org.locationtech.geowave.core.store.CloseableIterator;
import org.locationtech.geowave.core.store.api.DataStore;
import org.locationtech.geowave.core.store.api.Query;
import org.locationtech.geowave.core.store.api.QueryBuilder;
import org.locationtech.geowave.core.store.cli.store.DataStorePluginOptions;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GeowaveOperation(name={"clientCql"}, parentOperation=DebugSection.class)
@Parameters(commandDescription="cql client-side, primarily useful for consistency checking")
public class ClientSideCQLQuery
extends AbstractGeoWaveQuery {
    private static Logger LOGGER = LoggerFactory.getLogger(ClientSideCQLQuery.class);
    @Parameter(names={"--cql"}, required=true, description="CQL Filter executed client side")
    private String cql;
    private Filter filter;

    private void getFilter() {
        try {
            this.filter = ECQL.toFilter((String)this.cql);
        }
        catch (CQLException e) {
            LOGGER.warn("Unable to retrive filter", (Throwable)e);
        }
    }

    @Override
    protected long runQuery(GeotoolsFeatureDataAdapter adapter, String typeName, String indexName, DataStore dataStore, boolean debug, DataStorePluginOptions pluginOptions) {
        this.getFilter();
        long count = 0L;
        try (CloseableIterator it = dataStore.query((Query)((QueryBuilder)QueryBuilder.newBuilder().addTypeName(typeName).indexName(indexName)).build());){
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof SimpleFeature) || !this.filter.evaluate(o)) continue;
                if (debug) {
                    System.out.println(o);
                }
                ++count;
            }
        }
        return count;
    }
}

