/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.store;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Properties;
import org.locationtech.geowave.core.index.StringUtils;
import org.locationtech.geowave.core.index.VarintUtils;
import org.locationtech.geowave.core.index.persist.Persistable;
import org.locationtech.geowave.core.store.cli.store.DataStorePluginOptions;

public class PersistableStore
implements Persistable {
    private DataStorePluginOptions pluginOptions;

    public PersistableStore() {
    }

    public PersistableStore(DataStorePluginOptions options) {
        this.pluginOptions = options;
    }

    public DataStorePluginOptions getDataStoreOptions() {
        return this.pluginOptions;
    }

    public byte[] toBinary() {
        Properties strOptions = new Properties();
        this.pluginOptions.save(strOptions, null);
        ArrayList<byte[]> strOptionsBinary = new ArrayList<byte[]>(strOptions.size());
        int optionsLength = 0;
        for (String key : strOptions.stringPropertyNames()) {
            byte[] keyBinary = StringUtils.stringToBinary((String)key);
            byte[] valueBinary = StringUtils.stringToBinary((String)strOptions.getProperty(key));
            int entryLength = keyBinary.length + valueBinary.length + VarintUtils.unsignedIntByteLength((int)keyBinary.length) + VarintUtils.unsignedIntByteLength((int)valueBinary.length);
            ByteBuffer buf = ByteBuffer.allocate(entryLength);
            VarintUtils.writeUnsignedInt((int)keyBinary.length, (ByteBuffer)buf);
            buf.put(keyBinary);
            VarintUtils.writeUnsignedInt((int)valueBinary.length, (ByteBuffer)buf);
            buf.put(valueBinary);
            strOptionsBinary.add(buf.array());
            optionsLength += entryLength;
        }
        ByteBuffer buf = ByteBuffer.allocate(optionsLength += VarintUtils.unsignedIntByteLength((int)strOptionsBinary.size()));
        VarintUtils.writeUnsignedInt((int)strOptionsBinary.size(), (ByteBuffer)buf);
        for (byte[] strOption : strOptionsBinary) {
            buf.put(strOption);
        }
        return buf.array();
    }

    public void fromBinary(byte[] bytes) {
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        int configOptionLength = VarintUtils.readUnsignedInt((ByteBuffer)buf);
        Properties configOptions = new Properties();
        for (int i = 0; i < configOptionLength; ++i) {
            int keyLength = VarintUtils.readUnsignedInt((ByteBuffer)buf);
            byte[] keyBinary = new byte[keyLength];
            buf.get(keyBinary);
            int valueLength = VarintUtils.readUnsignedInt((ByteBuffer)buf);
            byte[] valueBinary = new byte[valueLength];
            buf.get(valueBinary);
            configOptions.put(StringUtils.stringFromBinary((byte[])keyBinary), StringUtils.stringFromBinary((byte[])valueBinary));
        }
        this.pluginOptions = new DataStorePluginOptions();
        this.pluginOptions.load(configOptions, null);
    }
}

