/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.partitioner;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.commons.codec.binary.Hex;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.JobContext;
import org.locationtech.geowave.analytic.PropertyManagement;
import org.locationtech.geowave.analytic.param.ParameterEnum;
import org.locationtech.geowave.core.index.ByteArray;
import org.locationtech.geowave.core.index.ByteArrayUtils;

public interface Partitioner<T>
extends Serializable {
    public void initialize(JobContext var1, Class<?> var2) throws IOException;

    public List<PartitionData> getCubeIdentifiers(T var1);

    public void partition(T var1, PartitionDataCallback var2) throws Exception;

    public Collection<ParameterEnum<?>> getParameters();

    public void setup(PropertyManagement var1, Class<?> var2, Configuration var3);

    public static class PartitionData
    implements Serializable,
    Writable {
        private static final long serialVersionUID = 1L;
        private ByteArray partitionKey;
        private ByteArray sortKey;
        private ByteArray groupId = null;
        private boolean isPrimary;

        public ByteArray getPartitionKey() {
            return this.partitionKey;
        }

        public ByteArray getSortKey() {
            return this.sortKey;
        }

        public ByteArray getCompositeKey() {
            return new ByteArray(ByteArrayUtils.combineArrays((byte[])this.partitionKey.getBytes(), (byte[])this.sortKey.getBytes()));
        }

        public ByteArray getGroupId() {
            return this.groupId;
        }

        public void setGroupId(ByteArray groupId) {
            this.groupId = groupId;
        }

        public boolean isPrimary() {
            return this.isPrimary;
        }

        public PartitionData() {
        }

        public PartitionData(ByteArray partitionKey, ByteArray sortKey, boolean primary) {
            this.partitionKey = partitionKey;
            this.sortKey = sortKey;
            this.isPrimary = primary;
        }

        public String toString() {
            return "PartitionData [partitionKey=" + Hex.encodeHexString((byte[])this.partitionKey.getBytes()) + ", sortKey=" + Hex.encodeHexString((byte[])this.sortKey.getBytes()) + ", groupId=" + (this.groupId == null ? "null" : this.groupId.getString()) + ", isPrimary=" + this.isPrimary + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.partitionKey == null ? 0 : this.partitionKey.hashCode());
            result = 31 * result + (this.sortKey == null ? 0 : this.sortKey.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PartitionData other = (PartitionData)obj;
            if (this.partitionKey == null ? other.partitionKey != null : !this.partitionKey.equals((Object)other.partitionKey)) {
                return false;
            }
            return !(this.sortKey == null ? other.sortKey != null : !this.sortKey.equals((Object)other.sortKey));
        }

        public void readFields(DataInput dInput) throws IOException {
            int partitionKeySize = dInput.readInt();
            byte[] partitionKeyBytes = new byte[partitionKeySize];
            dInput.readFully(partitionKeyBytes);
            this.partitionKey = new ByteArray(partitionKeyBytes);
            int sortKeySize = dInput.readInt();
            byte[] sortKeyBytes = new byte[sortKeySize];
            dInput.readFully(sortKeyBytes);
            this.sortKey = new ByteArray(sortKeyBytes);
            int groupIdSize = dInput.readInt();
            if (groupIdSize > 0) {
                byte[] groupIdIdBytes = new byte[groupIdSize];
                dInput.readFully(groupIdIdBytes);
                this.groupId = new ByteArray(groupIdIdBytes);
            }
            this.isPrimary = dInput.readBoolean();
        }

        public void write(DataOutput dOutput) throws IOException {
            byte[] outputPartitionKey = this.partitionKey.getBytes();
            dOutput.writeInt(outputPartitionKey.length);
            dOutput.write(outputPartitionKey);
            byte[] outputSortKey = this.sortKey.getBytes();
            dOutput.writeInt(outputSortKey.length);
            dOutput.write(outputSortKey);
            if (this.groupId != null) {
                byte[] groupOutputId = this.groupId.getBytes();
                dOutput.writeInt(groupOutputId.length);
                dOutput.write(groupOutputId);
            } else {
                dOutput.writeInt(0);
            }
            dOutput.writeBoolean(this.isPrimary);
        }

        public void setPrimary(boolean isPrimary) {
            this.isPrimary = isPrimary;
        }
    }

    public static interface PartitionDataCallback {
        public void partitionWith(PartitionData var1) throws Exception;
    }
}

