/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.partitioner;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.locationtech.geowave.analytic.ScopedJobConfiguration;
import org.locationtech.geowave.analytic.extract.DimensionExtractor;
import org.locationtech.geowave.analytic.extract.EmptyDimensionExtractor;
import org.locationtech.geowave.analytic.extract.SimpleFeatureGeometryExtractor;
import org.locationtech.geowave.analytic.partitioner.OrthodromicDistancePartitioner;
import org.locationtech.geowave.analytic.partitioner.Partitioner;
import org.locationtech.geowave.core.store.index.CommonIndexModel;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class BoundaryPartitioner
extends OrthodromicDistancePartitioner<Object> {
    private static final long serialVersionUID = 461679322447608507L;
    SimpleFeatureGeometryExtractor extractor = new SimpleFeatureGeometryExtractor();

    public BoundaryPartitioner() {
    }

    public BoundaryPartitioner(CoordinateReferenceSystem crs, CommonIndexModel indexModel, DimensionExtractor<Object> dimensionExtractor, double[] distancePerDimension, Unit<Length> geometricDistanceUnit) {
        super(crs, indexModel, new EchoExtractor(), distancePerDimension, geometricDistanceUnit);
    }

    @Override
    public List<Partitioner.PartitionData> getCubeIdentifiers(Object entry) {
        Geometry geom = this.extractor.getGeometry((SimpleFeature)entry);
        Coordinate[] coords = geom.getCoordinates();
        if (coords.length < 2) {
            return super.getCubeIdentifiers(geom);
        }
        ArrayList<Partitioner.PartitionData> r = new ArrayList<Partitioner.PartitionData>();
        for (int i = 0; i < coords.length - 1; ++i) {
            r.addAll(super.getCubeIdentifiers(geom.getFactory().createLineString(new Coordinate[]{coords[i], coords[i + 1]})));
        }
        return r;
    }

    @Override
    public void partition(Object entry, Partitioner.PartitionDataCallback callback) throws Exception {
        Geometry geom = this.extractor.getGeometry((SimpleFeature)entry);
        Coordinate[] coords = geom.getCoordinates();
        if (coords.length < 2) {
            super.partition(geom, callback);
        } else {
            for (int i = 0; i < coords.length - 1; ++i) {
                super.partition(geom.getFactory().createLineString(new Coordinate[]{coords[i], coords[i + 1]}), callback);
            }
        }
    }

    @Override
    public void initialize(ScopedJobConfiguration config) throws IOException {
        super.initialize(config);
        this.dimensionExtractor = new EchoExtractor();
    }

    private static class EchoExtractor
    extends EmptyDimensionExtractor<Object>
    implements DimensionExtractor<Object> {
        private static final long serialVersionUID = 1L;

        private EchoExtractor() {
        }

        @Override
        public Geometry getGeometry(Object anObject) {
            return (Geometry)anObject;
        }

        @Override
        public String getGroupID(Object anObject) {
            return "g";
        }
    }
}

