/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.param;

import java.util.Arrays;
import java.util.Collection;
import org.locationtech.geowave.analytic.param.BasicParameterHelper;
import org.locationtech.geowave.analytic.param.ParameterEnum;
import org.locationtech.geowave.analytic.param.ParameterHelper;

public class MapReduceParameters {
    public static final Collection<ParameterEnum<?>> getParameters() {
        return Arrays.asList(MRConfig.CONFIG_FILE, MRConfig.HDFS_BASE_DIR, MRConfig.HDFS_HOST_PORT, MRConfig.JOBTRACKER_HOST_PORT, MRConfig.YARN_RESOURCE_MANAGER);
    }

    public static enum MRConfig implements ParameterEnum
    {
        CONFIG_FILE(String.class, "conf", "MapReduce Configuration", true),
        HDFS_HOST_PORT(String.class, "hdfs", "HDFS hostname and port in the format hostname:port", true),
        HDFS_BASE_DIR(String.class, "hdfsbase", "Fully qualified path to the base directory in hdfs", true),
        YARN_RESOURCE_MANAGER(String.class, "resourceman", "Yarn resource manager hostname and port in the format hostname:port", true),
        JOBTRACKER_HOST_PORT(String.class, "jobtracker", "Hadoop job tracker hostname and port in the format hostname:port", true);

        private final ParameterHelper<?> helper;

        private MRConfig(Class baseClass, String name, String description, boolean hasArg) {
            this.helper = new BasicParameterHelper(this, baseClass, name, description, false, hasArg);
        }

        @Override
        public Enum<?> self() {
            return this;
        }

        public ParameterHelper<?> getHelper() {
            return this.helper;
        }
    }
}

