/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.param;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;
import org.locationtech.geowave.analytic.PropertyManagement;
import org.locationtech.geowave.analytic.param.ParameterHelper;
import org.locationtech.geowave.analytic.param.StoreParameters;
import org.locationtech.geowave.analytic.store.PersistableStore;
import org.locationtech.geowave.core.store.cli.store.DataStorePluginOptions;
import org.locationtech.geowave.mapreduce.input.GeoWaveInputFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputStoreParameterHelper
implements ParameterHelper<PersistableStore> {
    private static final long serialVersionUID = 1L;
    static final Logger LOGGER = LoggerFactory.getLogger(InputStoreParameterHelper.class);

    @Override
    public Class<PersistableStore> getBaseClass() {
        return PersistableStore.class;
    }

    @Override
    public void setValue(Configuration config, Class<?> scope, PersistableStore value) {
        DataStorePluginOptions options = value.getDataStoreOptions();
        GeoWaveInputFormat.setStoreOptions((Configuration)config, (DataStorePluginOptions)options);
    }

    @Override
    public PersistableStore getValue(JobContext context, Class<?> scope, PersistableStore defaultValue) {
        DataStorePluginOptions pluginOptions = GeoWaveInputFormat.getStoreOptions((JobContext)context);
        if (pluginOptions != null) {
            return new PersistableStore(pluginOptions);
        }
        return defaultValue;
    }

    @Override
    public PersistableStore getValue(PropertyManagement propertyManagement) {
        try {
            return (PersistableStore)propertyManagement.getProperty(StoreParameters.StoreParam.INPUT_STORE);
        }
        catch (Exception e) {
            LOGGER.error("Unable to deserialize data store", (Throwable)e);
            return null;
        }
    }

    @Override
    public void setValue(PropertyManagement propertyManagement, PersistableStore value) {
        propertyManagement.store(StoreParameters.StoreParam.INPUT_STORE, value);
    }
}

