/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.nn;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.locationtech.geowave.analytic.nn.DistanceProfile;
import org.locationtech.geowave.analytic.nn.NeighborList;
import org.locationtech.geowave.analytic.nn.NeighborListFactory;
import org.locationtech.geowave.core.index.ByteArray;

public class DefaultNeighborList<NNTYPE>
implements NeighborList<NNTYPE> {
    private final Map<ByteArray, NNTYPE> list = new HashMap<ByteArray, NNTYPE>();

    @Override
    public boolean add(DistanceProfile<?> distanceProfile, ByteArray id, NNTYPE value) {
        if (this.infer(id, value) == NeighborList.InferType.NONE) {
            this.list.put(id, value);
            return true;
        }
        return false;
    }

    @Override
    public NeighborList.InferType infer(ByteArray id, NNTYPE value) {
        if (this.list.containsKey(id)) {
            return NeighborList.InferType.SKIP;
        }
        return NeighborList.InferType.NONE;
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public Iterator<Map.Entry<ByteArray, NNTYPE>> iterator() {
        return this.list.entrySet().iterator();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public NNTYPE get(ByteArray key) {
        return this.list.get(key);
    }

    public static class DefaultNeighborListFactory<NNTYPE>
    implements NeighborListFactory<NNTYPE> {
        @Override
        public NeighborList<NNTYPE> buildNeighborList(ByteArray centerId, NNTYPE center) {
            return new DefaultNeighborList();
        }
    }
}

