/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.extract;

import java.util.Iterator;
import org.locationtech.geowave.analytic.extract.DimensionExtractor;
import org.locationtech.geowave.analytic.extract.EmptyDimensionExtractor;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class SimpleFeatureGeometryExtractor
extends EmptyDimensionExtractor<SimpleFeature>
implements DimensionExtractor<SimpleFeature> {
    private static final long serialVersionUID = 1L;

    @Override
    public Geometry getGeometry(SimpleFeature anObject) {
        Geometry geometry = (Geometry)anObject.getDefaultGeometry();
        int srid = SimpleFeatureGeometryExtractor.getSRID(anObject);
        geometry.setSRID(srid);
        return geometry;
    }

    protected static int getSRID(SimpleFeature geometryFeature) {
        CoordinateReferenceSystem crs = geometryFeature.getDefaultGeometryProperty().getDescriptor().getCoordinateReferenceSystem();
        if (crs == null) {
            return 4326;
        }
        ReferenceIdentifier id = SimpleFeatureGeometryExtractor.getFirst(crs.getIdentifiers());
        if (id == null) {
            return 4326;
        }
        return Integer.parseInt(id.getCode());
    }

    protected static final <T> ReferenceIdentifier getFirst(Iterable<ReferenceIdentifier> iterable) {
        ReferenceIdentifier id;
        if (iterable == null) {
            return null;
        }
        Iterator<ReferenceIdentifier> it = iterable.iterator();
        if (it.hasNext() && "EPSG".equals((id = it.next()).getCodeSpace())) {
            return id;
        }
        return null;
    }

    @Override
    public String getGroupID(SimpleFeature anObject) {
        Object v = anObject.getAttribute("GroupID");
        return v == null ? null : v.toString();
    }
}

