/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.distance;

import org.locationtech.geowave.analytic.distance.CoordinateCircleDistanceFn;
import org.locationtech.geowave.analytic.distance.DistanceFn;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.operation.distance.DistanceOp;
import org.opengis.feature.simple.SimpleFeature;

public class FeatureDistanceFn
implements DistanceFn<SimpleFeature> {
    private static final long serialVersionUID = 3824608959408031752L;
    private DistanceFn<Coordinate> coordinateDistanceFunction = new CoordinateCircleDistanceFn();

    public FeatureDistanceFn() {
    }

    public FeatureDistanceFn(DistanceFn<Coordinate> coordinateDistanceFunction) {
        this.coordinateDistanceFunction = coordinateDistanceFunction;
    }

    public DistanceFn<Coordinate> getCoordinateDistanceFunction() {
        return this.coordinateDistanceFunction;
    }

    public void setCoordinateDistanceFunction(DistanceFn<Coordinate> coordinateDistanceFunction) {
        this.coordinateDistanceFunction = coordinateDistanceFunction;
    }

    private Geometry getGeometry(SimpleFeature x) {
        for (Object attr : x.getAttributes()) {
            if (!(attr instanceof Geometry)) continue;
            return (Geometry)attr;
        }
        return (Geometry)x.getDefaultGeometry();
    }

    @Override
    public double measure(SimpleFeature x, SimpleFeature y) {
        double dist = Double.MAX_VALUE;
        Coordinate[] coords = new DistanceOp(this.getGeometry(x), this.getGeometry(y)).nearestPoints();
        for (int i = 0; i < coords.length; ++i) {
            for (int j = i + 1; j < coords.length; ++j) {
                dist = Math.min(dist, this.coordinateDistanceFunction.measure(coords[j], coords[i]));
            }
        }
        return dist;
    }
}

