/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.distance;

import org.locationtech.geowave.analytic.distance.DistanceFn;
import org.locationtech.jts.geom.Coordinate;

public class CoordinateEuclideanDistanceFn
implements DistanceFn<Coordinate> {
    private static final long serialVersionUID = 888639577783179566L;

    @Override
    public double measure(Coordinate x, Coordinate y) {
        return Math.sqrt(Math.pow(x.x - y.x, 2.0) + Math.pow(x.y - y.y, 2.0) + Math.pow(CoordinateEuclideanDistanceFn.filter(x.z) - CoordinateEuclideanDistanceFn.filter(y.z), 2.0));
    }

    private static double filter(double x) {
        return Double.isNaN(x) ? 0.0 : x;
    }
}

