/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.distance;

import org.locationtech.geowave.analytic.distance.DistanceFn;
import org.locationtech.jts.geom.Coordinate;

public class CoordinateCosineDistanceFn
implements DistanceFn<Coordinate> {
    private static final long serialVersionUID = 2074200104626591273L;

    @Override
    public double measure(Coordinate x, Coordinate y) {
        double ab = x.x * y.x + x.y * y.y + x.z * y.z;
        double norma = Math.sqrt(Math.pow(x.x, 2.0) + Math.pow(x.y, 2.0) + Math.pow(x.z, 2.0));
        double normb = Math.sqrt(Math.pow(y.x, 2.0) + Math.pow(y.y, 2.0) + Math.pow(y.z, 2.0));
        return ab / (norma * normb);
    }
}

