/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.distance;

import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.GeodeticCalculator;
import org.geotools.referencing.datum.DefaultEllipsoid;
import org.locationtech.geowave.analytic.distance.DistanceFn;
import org.locationtech.jts.geom.Coordinate;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoordinateCircleDistanceFn
implements DistanceFn<Coordinate> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CoordinateCircleDistanceFn.class);
    private static final long serialVersionUID = -1245559892132762143L;
    protected static final CoordinateReferenceSystem DEFAULT_CRS;

    @Override
    public double measure(Coordinate c1, Coordinate c2) {
        try {
            return JTS.orthodromicDistance((Coordinate)c1, (Coordinate)c2, (CoordinateReferenceSystem)this.getCRS());
        }
        catch (TransformException e) {
            throw new RuntimeException("Failed to transform coordinates to provided CRS", e);
        }
        catch (AssertionError ae) {
            LOGGER.info("when distance is too close(0.05 meter), it fails the tolerance test", (Throwable)((Object)ae));
            GeodeticCalculator calc = new GeodeticCalculator(this.getCRS());
            calc.setStartingGeographicPoint(c1.x, c1.y);
            calc.setDestinationGeographicPoint(c2.x, c2.y);
            return ((DefaultEllipsoid)calc.getEllipsoid()).orthodromicDistance(calc.getStartingGeographicPoint().getX(), calc.getStartingGeographicPoint().getY(), calc.getDestinationGeographicPoint().getX(), calc.getDestinationGeographicPoint().getY());
        }
    }

    protected CoordinateReferenceSystem getCRS() {
        return DEFAULT_CRS;
    }

    static {
        try {
            DEFAULT_CRS = CRS.decode((String)"EPSG:4326", (boolean)true);
        }
        catch (FactoryException e) {
            throw new RuntimeException("Failed to load default EPSG:4326 coordinate reference system", e);
        }
    }
}

