/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.clustering;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;
import org.locationtech.geowave.analytic.AnalyticItemWrapper;
import org.locationtech.geowave.analytic.PropertyManagement;
import org.locationtech.geowave.analytic.ScopedJobConfiguration;
import org.locationtech.geowave.analytic.clustering.CentroidManager;
import org.locationtech.geowave.analytic.clustering.CentroidManagerGeoWave;
import org.locationtech.geowave.analytic.clustering.CentroidPairing;
import org.locationtech.geowave.analytic.distance.DistanceFn;
import org.locationtech.geowave.analytic.distance.FeatureCentroidDistanceFn;
import org.locationtech.geowave.analytic.kmeans.AssociationNotification;
import org.locationtech.geowave.analytic.kmeans.CentroidAssociationFn;
import org.locationtech.geowave.analytic.param.CentroidParameters;
import org.locationtech.geowave.analytic.param.CommonParameters;
import org.locationtech.geowave.analytic.param.GlobalParameters;
import org.locationtech.geowave.analytic.param.ParameterEnum;
import org.slf4j.Logger;

public class NestedGroupCentroidAssignment<T> {
    private final CentroidAssociationFn<T> associationdFunction = new CentroidAssociationFn();
    private final CentroidManager<T> centroidManager;
    private final int endZoomLevel;
    private final String parentBatchID;

    public NestedGroupCentroidAssignment(CentroidManager<T> centroidManager, int endZoomLevel, String parentBatchID, DistanceFn<T> distanceFunction) {
        this.centroidManager = centroidManager;
        this.endZoomLevel = endZoomLevel;
        this.parentBatchID = parentBatchID;
        this.associationdFunction.setDistanceFunction(distanceFunction);
    }

    public NestedGroupCentroidAssignment(JobContext context, Class<?> scope, Logger logger) throws InstantiationException, IllegalAccessException, IOException {
        ScopedJobConfiguration config = new ScopedJobConfiguration(context.getConfiguration(), scope, logger);
        this.endZoomLevel = config.getInt(CentroidParameters.Centroid.ZOOM_LEVEL, 1);
        this.parentBatchID = config.getString(GlobalParameters.Global.PARENT_BATCH_ID, config.getString(GlobalParameters.Global.BATCH_ID, null));
        DistanceFn distanceFunction = config.getInstance(CommonParameters.Common.DISTANCE_FUNCTION_CLASS, DistanceFn.class, FeatureCentroidDistanceFn.class);
        this.associationdFunction.setDistanceFunction(distanceFunction);
        this.centroidManager = new CentroidManagerGeoWave(context, scope);
    }

    public static void setZoomLevel(Configuration config, Class<?> scope, int zoomLevel) {
        CentroidParameters.Centroid.ZOOM_LEVEL.getHelper().setValue(config, scope, zoomLevel);
    }

    public static void setParentBatchID(Configuration config, Class<?> scope, String parentID) {
        GlobalParameters.Global.PARENT_BATCH_ID.getHelper().setValue(config, scope, parentID);
    }

    public static Collection<ParameterEnum<?>> getParameters() {
        HashSet params = new HashSet();
        params.addAll(CentroidManagerGeoWave.getParameters());
        params.addAll(Arrays.asList(CentroidParameters.Centroid.ZOOM_LEVEL, GlobalParameters.Global.PARENT_BATCH_ID, CommonParameters.Common.DISTANCE_FUNCTION_CLASS));
        return params;
    }

    public List<AnalyticItemWrapper<T>> getCentroidsForGroup(String groupID) throws IOException {
        return this.centroidManager.getCentroidsForGroup(groupID);
    }

    public String getGroupForLevel(AnalyticItemWrapper<T> item) throws IOException {
        final GroupHolder group = new GroupHolder();
        group.setGroupID(item.getGroupID());
        int currentLevel = item.getZoomLevel();
        while (this.endZoomLevel != currentLevel) {
            List<AnalyticItemWrapper<T>> centroids = this.centroidManager.getCentroidsForGroup(this.parentBatchID, group.getGroupID());
            if (centroids.size() == 0) {
                throw new IOException("Cannot find group " + group.getGroupID());
            }
            this.associationdFunction.compute(item, centroids, new AssociationNotification<T>(){

                @Override
                public void notify(CentroidPairing<T> pairing) {
                    group.setGroupID(pairing.getCentroid().getID());
                }
            });
            currentLevel = centroids.get(0).getZoomLevel() + 1;
        }
        return group.getGroupID();
    }

    public double findCentroidForLevel(AnalyticItemWrapper<T> item, final AssociationNotification<T> associationNotification) throws IOException {
        final GroupHolder group = new GroupHolder();
        group.setGroupID(item.getGroupID());
        double currentDistance = Double.NaN;
        int currentLevel = item.getZoomLevel();
        boolean atEndLevel = false;
        while (!atEndLevel) {
            List<AnalyticItemWrapper<T>> centroids;
            boolean reachedEndLevel;
            atEndLevel = reachedEndLevel = currentLevel == this.endZoomLevel;
            List<AnalyticItemWrapper<T>> list = centroids = currentLevel == this.endZoomLevel ? this.centroidManager.getCentroidsForGroup(group.getGroupID()) : this.centroidManager.getCentroidsForGroup(this.parentBatchID, group.getGroupID());
            if (centroids.size() == 0) {
                throw new IOException("Cannot find group " + group.getGroupID());
            }
            currentDistance = this.associationdFunction.compute(item, centroids, new AssociationNotification<T>(){

                @Override
                public void notify(CentroidPairing<T> pairing) {
                    group.setGroupID(pairing.getCentroid().getID());
                    if (reachedEndLevel) {
                        associationNotification.notify(pairing);
                    }
                }
            });
            currentLevel = centroids.get(0).getZoomLevel() + 1;
        }
        return currentDistance;
    }

    public static void setParameters(Configuration config, Class<?> scope, PropertyManagement runTimeProperties) {
        CentroidManagerGeoWave.setParameters(config, scope, runTimeProperties);
        runTimeProperties.setConfig(new ParameterEnum[]{CommonParameters.Common.DISTANCE_FUNCTION_CLASS, CentroidParameters.Centroid.ZOOM_LEVEL, GlobalParameters.Global.BATCH_ID, GlobalParameters.Global.PARENT_BATCH_ID}, config, scope);
    }

    private class GroupHolder {
        private String groupID;

        private GroupHolder() {
        }

        public String getGroupID() {
            return this.groupID;
        }

        public void setGroupID(String groupID) {
            this.groupID = groupID;
        }
    }
}

