/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.clustering;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.io.Writable;
import org.locationtech.geowave.analytic.AnalyticItemWrapperFactory;
import org.locationtech.geowave.analytic.clustering.CentroidManagerGeoWave;
import org.locationtech.geowave.core.index.StringUtils;
import org.locationtech.geowave.core.index.numeric.MultiDimensionalNumericData;
import org.locationtech.geowave.core.store.CloseableIterator;
import org.locationtech.geowave.core.store.adapter.FieldDescriptor;
import org.locationtech.geowave.core.store.adapter.FieldDescriptorBuilder;
import org.locationtech.geowave.core.store.adapter.InternalAdapterStore;
import org.locationtech.geowave.core.store.adapter.PersistentAdapterStore;
import org.locationtech.geowave.core.store.api.DataStore;
import org.locationtech.geowave.core.store.api.DataTypeAdapter;
import org.locationtech.geowave.core.store.api.Index;
import org.locationtech.geowave.core.store.api.Query;
import org.locationtech.geowave.core.store.api.QueryBuilder;
import org.locationtech.geowave.core.store.api.RowBuilder;
import org.locationtech.geowave.core.store.cli.store.DataStorePluginOptions;
import org.locationtech.geowave.core.store.data.IndexedPersistenceEncoding;
import org.locationtech.geowave.core.store.data.field.FieldReader;
import org.locationtech.geowave.core.store.data.field.FieldUtils;
import org.locationtech.geowave.core.store.index.CommonIndexModel;
import org.locationtech.geowave.core.store.index.IndexStore;
import org.locationtech.geowave.core.store.index.NullIndex;
import org.locationtech.geowave.core.store.query.constraints.QueryConstraints;
import org.locationtech.geowave.core.store.query.filter.QueryFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistortionGroupManagement {
    static final Logger LOGGER = LoggerFactory.getLogger(DistortionGroupManagement.class);
    public static final Index DISTORTIONS_INDEX = new NullIndex("DISTORTIONS");
    public static final String[] DISTORTIONS_INDEX_ARRAY = new String[]{DISTORTIONS_INDEX.getName()};
    final DataStore dataStore;
    final IndexStore indexStore;
    final PersistentAdapterStore adapterStore;
    final InternalAdapterStore internalAdapterStore;

    public DistortionGroupManagement(DataStorePluginOptions dataStoreOptions) {
        this.dataStore = dataStoreOptions.createDataStore();
        this.indexStore = dataStoreOptions.createIndexStore();
        this.adapterStore = dataStoreOptions.createAdapterStore();
        this.internalAdapterStore = dataStoreOptions.createInternalAdapterStore();
        DistortionDataAdapter adapter = new DistortionDataAdapter();
        this.dataStore.addType((DataTypeAdapter)adapter, new Index[]{DISTORTIONS_INDEX});
    }

    public <T> int retainBestGroups(AnalyticItemWrapperFactory<T> itemWrapperFactory, String dataTypeId, String indexId, String batchId, int level) {
        try {
            HashMap<String, DistortionGroup> groupDistortions = new HashMap<String, DistortionGroup>();
            CloseableIterator it = this.dataStore.query((Query)((QueryBuilder)((QueryBuilder)QueryBuilder.newBuilder().addTypeName("distortion").indexName(DISTORTIONS_INDEX.getName())).constraints((QueryConstraints)new BatchIdQuery(batchId))).build());
            Object object = null;
            try {
                while (it.hasNext()) {
                    DistortionEntry entry = (DistortionEntry)it.next();
                    String groupID = entry.getGroupId();
                    Integer clusterCount = entry.getClusterCount();
                    Double distortion = entry.getDistortionValue();
                    DistortionGroup grp = (DistortionGroup)groupDistortions.get(groupID);
                    if (grp == null) {
                        grp = new DistortionGroup(groupID);
                        groupDistortions.put(groupID, grp);
                    }
                    grp.addPair(clusterCount, distortion);
                }
            }
            catch (Throwable entry) {
                object = entry;
                throw entry;
            }
            finally {
                if (it != null) {
                    if (object != null) {
                        try {
                            it.close();
                        }
                        catch (Throwable entry) {
                            ((Throwable)object).addSuppressed(entry);
                        }
                    } else {
                        it.close();
                    }
                }
            }
            CentroidManagerGeoWave<T> centroidManager = new CentroidManagerGeoWave<T>(this.dataStore, this.indexStore, this.adapterStore, itemWrapperFactory, dataTypeId, this.internalAdapterStore.getAdapterId(dataTypeId), indexId, batchId, level);
            for (DistortionGroup grp : groupDistortions.values()) {
                int optimalK = grp.bestCount();
                String kbatchId = batchId + "_" + optimalK;
                centroidManager.transferBatch(kbatchId, grp.getGroupID());
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            LOGGER.error("Cannot determine groups for batch", (Throwable)ex);
            return 1;
        }
        return 0;
    }

    public static class DistortionDataAdapter
    implements DataTypeAdapter<DistortionEntry> {
        public static final String ADAPTER_TYPE_NAME = "distortion";
        private static final String DISTORTION_FIELD_NAME = "distortion";
        private static final FieldDescriptor<Double> DESC = new FieldDescriptorBuilder(Double.class).fieldName("distortion").build();
        private static final FieldDescriptor<?>[] DESC_ARRAY = new FieldDescriptor[]{DESC};

        public String getTypeName() {
            return "distortion";
        }

        public byte[] getDataId(DistortionEntry entry) {
            return entry.getDataId();
        }

        public FieldReader<Object> getReader(String fieldId) {
            if ("distortion".equals(fieldId)) {
                return FieldUtils.getDefaultReaderForClass(Double.class);
            }
            return null;
        }

        public byte[] toBinary() {
            return new byte[0];
        }

        public void fromBinary(byte[] bytes) {
        }

        public Object getFieldValue(DistortionEntry entry, String fieldName) {
            return entry.getDistortionValue();
        }

        public Class<DistortionEntry> getDataClass() {
            return DistortionEntry.class;
        }

        public RowBuilder<DistortionEntry> newRowBuilder(FieldDescriptor<?>[] outputFieldDescriptors) {
            return new RowBuilder<DistortionEntry>(){
                Double fieldValue;

                public void setField(String fieldName, Object fieldValue) {
                    if ("distortion".equals(fieldName) && fieldValue instanceof Double) {
                        this.fieldValue = (Double)fieldValue;
                    }
                }

                public void setFields(Map<String, Object> values) {
                    values.entrySet().forEach(e -> this.setField((String)e.getKey(), e.getValue()));
                }

                public DistortionEntry buildRow(byte[] dataId) {
                    return new DistortionEntry(dataId, this.fieldValue);
                }
            };
        }

        public FieldDescriptor<?>[] getFieldDescriptors() {
            return DESC_ARRAY;
        }

        public FieldDescriptor<?> getFieldDescriptor(String fieldName) {
            return DESC;
        }
    }

    private static class DistortionGroup {
        final String groupID;
        final List<Pair<Integer, Double>> clusterCountToDistortion = new ArrayList<Pair<Integer, Double>>();

        public DistortionGroup(String groupID) {
            this.groupID = groupID;
        }

        public void addPair(Integer count, Double distortion) {
            this.clusterCountToDistortion.add((Pair<Integer, Double>)Pair.of((Object)count, (Object)distortion));
        }

        public String getGroupID() {
            return this.groupID;
        }

        public int bestCount() {
            Collections.sort(this.clusterCountToDistortion, new Comparator<Pair<Integer, Double>>(){

                @Override
                public int compare(Pair<Integer, Double> arg0, Pair<Integer, Double> arg1) {
                    return ((Integer)arg0.getKey()).compareTo((Integer)arg1.getKey());
                }
            });
            double maxJump = -1.0;
            Integer jumpIdx = -1;
            Double oldD = 0.0;
            for (Pair<Integer, Double> pair : this.clusterCountToDistortion) {
                Double jump = (Double)pair.getValue() - oldD;
                if (jump > maxJump) {
                    maxJump = jump;
                    jumpIdx = (Integer)pair.getKey();
                }
                oldD = (Double)pair.getValue();
            }
            return jumpIdx;
        }
    }

    public static class DistortionEntry
    implements Writable {
        private String groupId;
        private String batchId;
        private Integer clusterCount;
        private Double distortionValue;

        public DistortionEntry() {
        }

        public DistortionEntry(String groupId, String batchId, Integer clusterCount, Double distortionValue) {
            this.groupId = groupId;
            this.batchId = batchId;
            this.clusterCount = clusterCount;
            this.distortionValue = distortionValue;
        }

        private DistortionEntry(byte[] dataId, Double distortionValue) {
            String dataIdStr = StringUtils.stringFromBinary((byte[])dataId);
            String[] split = dataIdStr.split("/");
            this.batchId = split[0];
            this.groupId = split[1];
            this.clusterCount = Integer.parseInt(split[2]);
            this.distortionValue = distortionValue;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public Integer getClusterCount() {
            return this.clusterCount;
        }

        public Double getDistortionValue() {
            return this.distortionValue;
        }

        private byte[] getDataId() {
            return StringUtils.stringToBinary((String)(this.batchId + "/" + this.groupId + "/" + this.clusterCount));
        }

        public void write(DataOutput out) throws IOException {
            out.writeUTF(this.groupId);
            out.writeUTF(this.batchId);
            out.writeInt(this.clusterCount);
            out.writeDouble(this.distortionValue);
        }

        public void readFields(DataInput in) throws IOException {
            this.groupId = in.readUTF();
            this.batchId = in.readUTF();
            this.clusterCount = in.readInt();
            this.distortionValue = in.readDouble();
        }
    }

    public static class BatchIdQuery
    implements QueryConstraints {
        String batchId;

        public BatchIdQuery() {
        }

        public BatchIdQuery(String batchId) {
            this.batchId = batchId;
        }

        public List<QueryFilter> createFilters(Index index) {
            return Collections.singletonList(new BatchIdFilter(this.batchId));
        }

        public List<MultiDimensionalNumericData> getIndexConstraints(Index index) {
            return Collections.emptyList();
        }

        public byte[] toBinary() {
            return StringUtils.stringToBinary((String)this.batchId);
        }

        public void fromBinary(byte[] bytes) {
            this.batchId = StringUtils.stringFromBinary((byte[])bytes);
        }
    }

    public static class BatchIdFilter
    implements QueryFilter {
        String batchId;

        public BatchIdFilter() {
        }

        public BatchIdFilter(String batchId) {
            this.batchId = batchId;
        }

        public boolean accept(CommonIndexModel indexModel, IndexedPersistenceEncoding<?> persistenceEncoding) {
            return new DistortionEntry(persistenceEncoding.getDataId(), 0.0).batchId.equals(this.batchId);
        }

        public byte[] toBinary() {
            return StringUtils.stringToBinary((String)this.batchId);
        }

        public void fromBinary(byte[] bytes) {
            this.batchId = StringUtils.stringFromBinary((byte[])bytes);
        }
    }
}

