/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.clustering;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.locationtech.geowave.adapter.vector.FeatureDataAdapter;
import org.locationtech.geowave.analytic.AnalyticFeature;
import org.locationtech.geowave.analytic.PropertyManagement;
import org.locationtech.geowave.analytic.extract.DimensionExtractor;
import org.locationtech.geowave.analytic.param.CentroidParameters;
import org.locationtech.geowave.analytic.param.CommonParameters;
import org.locationtech.geowave.analytic.param.StoreParameters;
import org.locationtech.geowave.analytic.store.PersistableStore;
import org.locationtech.geowave.core.geotime.index.SpatialDimensionalityTypeProvider;
import org.locationtech.geowave.core.geotime.index.SpatialOptions;
import org.locationtech.geowave.core.geotime.store.query.ExplicitSpatialQuery;
import org.locationtech.geowave.core.index.ByteArray;
import org.locationtech.geowave.core.index.IndexMetaData;
import org.locationtech.geowave.core.index.QueryRanges;
import org.locationtech.geowave.core.store.CloseableIterator;
import org.locationtech.geowave.core.store.adapter.AdapterStore;
import org.locationtech.geowave.core.store.adapter.PersistentAdapterStore;
import org.locationtech.geowave.core.store.api.DataTypeAdapter;
import org.locationtech.geowave.core.store.api.Index;
import org.locationtech.geowave.core.store.index.IndexStore;
import org.locationtech.geowave.core.store.util.DataStoreUtils;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusteringUtils {
    public static final String CLUSTERING_CRS = "EPSG:4326";
    static final Logger LOGGER = LoggerFactory.getLogger(ClusteringUtils.class);

    private static DataTypeAdapter<?> createAdapter(String sampleDataTypeId, String sampleDataNamespaceURI, AdapterStore adapterStore, String[] dimensionNames) {
        FeatureDataAdapter adapter = AnalyticFeature.createGeometryFeatureAdapter(sampleDataTypeId, dimensionNames, sampleDataNamespaceURI, CLUSTERING_CRS);
        ByteArray dbId = new ByteArray(sampleDataTypeId);
        if (!adapterStore.adapterExists((Object)dbId)) {
            adapterStore.addAdapter((DataTypeAdapter)adapter);
            return adapter;
        }
        return adapterStore.getAdapter((Object)dbId);
    }

    public static DataTypeAdapter[] getAdapters(PropertyManagement propertyManagement) throws IOException {
        PersistableStore store = (PersistableStore)StoreParameters.StoreParam.INPUT_STORE.getHelper().getValue(propertyManagement);
        PersistentAdapterStore adapterStore = store.getDataStoreOptions().createAdapterStore();
        return adapterStore.getAdapters();
    }

    public static Index[] getIndices(PropertyManagement propertyManagement) {
        PersistableStore store = (PersistableStore)StoreParameters.StoreParam.INPUT_STORE.getHelper().getValue(propertyManagement);
        IndexStore indexStore = store.getDataStoreOptions().createIndexStore();
        try (CloseableIterator it = indexStore.getIndices();){
            LinkedList<Object> indices = new LinkedList<Object>();
            while (it.hasNext()) {
                indices.add(it.next());
            }
            Index[] result = new Index[indices.size()];
            indices.toArray(result);
            Index[] indexArray = result;
            return indexArray;
        }
    }

    protected static QueryRanges getGeoWaveRangesForQuery(Polygon polygon) {
        Index index = SpatialDimensionalityTypeProvider.createIndexFromOptions((SpatialOptions)new SpatialOptions());
        QueryRanges ranges = DataStoreUtils.constraintsToQueryRanges((List)new ExplicitSpatialQuery((Geometry)polygon).getIndexConstraints(index), (Index)index, null, (int)-1, (IndexMetaData[])new IndexMetaData[0]);
        return ranges;
    }

    public static Index createIndex(PropertyManagement propertyManagement) {
        PersistableStore store = (PersistableStore)StoreParameters.StoreParam.INPUT_STORE.getHelper().getValue(propertyManagement);
        IndexStore indexStore = store.getDataStoreOptions().createIndexStore();
        return indexStore.getIndex(propertyManagement.getPropertyAsString(CentroidParameters.Centroid.INDEX_NAME));
    }

    public static DataTypeAdapter<?> createAdapter(PropertyManagement propertyManagement) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<DimensionExtractor> dimensionExtractorClass = propertyManagement.getPropertyAsClass(CommonParameters.Common.DIMENSION_EXTRACT_CLASS, DimensionExtractor.class);
        return ClusteringUtils.createAdapter(propertyManagement.getPropertyAsString(CentroidParameters.Centroid.DATA_TYPE_ID), propertyManagement.getPropertyAsString(CentroidParameters.Centroid.DATA_NAMESPACE_URI, "http://www.opengis.net/gml"), (AdapterStore)((PersistableStore)StoreParameters.StoreParam.INPUT_STORE.getHelper().getValue(propertyManagement)).getDataStoreOptions().createAdapterStore(), dimensionExtractorClass.newInstance().getDimensionNames());
    }
}

