/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.clustering;

import org.locationtech.geowave.analytic.AnalyticItemWrapper;

public class CentroidPairing<T> {
    private AnalyticItemWrapper<T> centroid;
    private AnalyticItemWrapper<T> pairedItem;
    private double distance;

    public CentroidPairing() {
    }

    public CentroidPairing(AnalyticItemWrapper<T> centroid, AnalyticItemWrapper<T> pairedItem, double distance) {
        this.centroid = centroid;
        this.pairedItem = pairedItem;
        this.distance = distance;
    }

    public AnalyticItemWrapper<T> getCentroid() {
        return this.centroid;
    }

    public void setCentroid(AnalyticItemWrapper<T> centroid) {
        this.centroid = centroid;
    }

    public AnalyticItemWrapper<T> getPairedItem() {
        return this.pairedItem;
    }

    public void setPairedItem(AnalyticItemWrapper<T> pairedItem) {
        this.pairedItem = pairedItem;
    }

    public double getDistance() {
        return this.distance;
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.centroid == null ? 0 : this.centroid.hashCode());
        long temp = Double.doubleToLongBits(this.distance);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.pairedItem == null ? 0 : this.pairedItem.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CentroidPairing other = (CentroidPairing)obj;
        if (this.centroid == null ? other.centroid != null : !this.centroid.equals(other.centroid)) {
            return false;
        }
        if (Double.doubleToLongBits(this.distance) != Double.doubleToLongBits(other.distance)) {
            return false;
        }
        return !(this.pairedItem == null ? other.pairedItem != null : !this.pairedItem.equals(other.pairedItem));
    }
}

