/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.clustering;

import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.FilterFactoryImpl;
import org.locationtech.geowave.adapter.vector.FeatureDataAdapter;
import org.locationtech.geowave.analytic.AnalyticFeature;
import org.locationtech.geowave.analytic.AnalyticItemWrapper;
import org.locationtech.geowave.analytic.AnalyticItemWrapperFactory;
import org.locationtech.geowave.analytic.PropertyManagement;
import org.locationtech.geowave.analytic.ScopedJobConfiguration;
import org.locationtech.geowave.analytic.clustering.CentroidItemWrapperFactory;
import org.locationtech.geowave.analytic.clustering.CentroidManager;
import org.locationtech.geowave.analytic.clustering.exception.MatchingCentroidNotFoundException;
import org.locationtech.geowave.analytic.param.CentroidParameters;
import org.locationtech.geowave.analytic.param.GlobalParameters;
import org.locationtech.geowave.analytic.param.ParameterEnum;
import org.locationtech.geowave.analytic.param.StoreParameters;
import org.locationtech.geowave.analytic.store.PersistableStore;
import org.locationtech.geowave.core.geotime.index.SpatialDimensionalityTypeProvider;
import org.locationtech.geowave.core.geotime.index.SpatialOptions;
import org.locationtech.geowave.core.geotime.store.GeotoolsFeatureDataAdapter;
import org.locationtech.geowave.core.geotime.store.query.api.VectorQueryBuilder;
import org.locationtech.geowave.core.index.StringUtils;
import org.locationtech.geowave.core.store.CloseableIterator;
import org.locationtech.geowave.core.store.adapter.InternalDataAdapter;
import org.locationtech.geowave.core.store.adapter.PersistentAdapterStore;
import org.locationtech.geowave.core.store.api.DataStore;
import org.locationtech.geowave.core.store.api.DataTypeAdapter;
import org.locationtech.geowave.core.store.api.Index;
import org.locationtech.geowave.core.store.api.Query;
import org.locationtech.geowave.core.store.api.QueryBuilder;
import org.locationtech.geowave.core.store.api.Writer;
import org.locationtech.geowave.core.store.index.IndexStore;
import org.locationtech.geowave.mapreduce.GeoWaveConfiguratorBase;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.filter.Filter;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CentroidManagerGeoWave<T>
implements CentroidManager<T> {
    static final Logger LOGGER = LoggerFactory.getLogger(CentroidManagerGeoWave.class);
    private static final ParameterEnum<?>[] MY_PARAMS = new ParameterEnum[]{StoreParameters.StoreParam.INPUT_STORE, GlobalParameters.Global.BATCH_ID, CentroidParameters.Centroid.DATA_TYPE_ID, CentroidParameters.Centroid.DATA_NAMESPACE_URI, CentroidParameters.Centroid.INDEX_NAME, CentroidParameters.Centroid.WRAPPER_FACTORY_CLASS, CentroidParameters.Centroid.ZOOM_LEVEL};
    private String batchId;
    private int level = 0;
    private AnalyticItemWrapperFactory<T> centroidFactory;
    private GeotoolsFeatureDataAdapter adapter;
    private String centroidDataTypeId;
    private DataStore dataStore;
    private IndexStore indexStore;
    private Index index;
    private final int capacity = 100;
    private final LRUMap groupToCentroid = new LRUMap(100);

    public CentroidManagerGeoWave(DataStore dataStore, IndexStore indexStore, PersistentAdapterStore adapterStore, AnalyticItemWrapperFactory<T> centroidFactory, String centroidDataTypeId, short centroidInternalAdapterId, String indexName, String batchId, int level) {
        this.centroidFactory = centroidFactory;
        this.level = level;
        this.batchId = batchId;
        this.dataStore = dataStore;
        this.indexStore = indexStore;
        this.centroidDataTypeId = centroidDataTypeId;
        this.index = indexStore.getIndex(indexName);
        this.adapter = (GeotoolsFeatureDataAdapter)((InternalDataAdapter)adapterStore.getAdapter((Object)centroidInternalAdapterId)).getAdapter();
    }

    public CentroidManagerGeoWave(PropertyManagement properties) throws IOException {
        Class<CentroidManagerGeoWave> scope = CentroidManagerGeoWave.class;
        Configuration configuration = new Configuration();
        properties.setJobConfiguration(configuration, scope);
        this.init((JobContext)Job.getInstance((Configuration)configuration), scope, LOGGER);
    }

    public CentroidManagerGeoWave(JobContext context, Class<?> scope) throws IOException {
        this(context, scope, LOGGER);
    }

    public CentroidManagerGeoWave(JobContext context, Class<?> scope, Logger logger) throws IOException {
        this.init(context, scope, logger);
    }

    private void init(JobContext context, Class<?> scope, Logger logger) throws IOException {
        ScopedJobConfiguration scopedJob = new ScopedJobConfiguration(context.getConfiguration(), scope, logger);
        try {
            this.centroidFactory = (AnalyticItemWrapperFactory)((Object)CentroidParameters.Centroid.WRAPPER_FACTORY_CLASS.getHelper().getValue(context, scope, CentroidItemWrapperFactory.class));
            this.centroidFactory.initialize(context, scope, logger);
        }
        catch (Exception e1) {
            LOGGER.error("Cannot instantiate " + GeoWaveConfiguratorBase.enumToConfKey(this.getClass(), (Enum)CentroidParameters.Centroid.WRAPPER_FACTORY_CLASS));
            throw new IOException(e1);
        }
        this.level = scopedJob.getInt(CentroidParameters.Centroid.ZOOM_LEVEL, 1);
        this.centroidDataTypeId = scopedJob.getString(CentroidParameters.Centroid.DATA_TYPE_ID, "centroid");
        this.batchId = scopedJob.getString(GlobalParameters.Global.BATCH_ID, Long.toString(Calendar.getInstance().getTime().getTime()));
        String indexName = scopedJob.getString(CentroidParameters.Centroid.INDEX_NAME, SpatialDimensionalityTypeProvider.createIndexFromOptions((SpatialOptions)new SpatialOptions()).getName());
        PersistableStore store = StoreParameters.StoreParam.INPUT_STORE.getHelper().getValue(context, scope, null);
        this.dataStore = store.getDataStoreOptions().createDataStore();
        this.indexStore = store.getDataStoreOptions().createIndexStore();
        this.index = this.indexStore.getIndex(indexName);
        PersistentAdapterStore adapterStore = store.getDataStoreOptions().createAdapterStore();
        this.adapter = (GeotoolsFeatureDataAdapter)((InternalDataAdapter)adapterStore.getAdapter((Object)store.getDataStoreOptions().createInternalAdapterStore().getAdapterId(this.centroidDataTypeId))).getAdapter();
    }

    @Override
    public AnalyticItemWrapper<T> createNextCentroid(T feature, String groupID, Coordinate coordinate, String[] extraNames, double[] extraValues) {
        return this.centroidFactory.createNextItem(feature, groupID, coordinate, extraNames, extraValues);
    }

    @Override
    public void clear() {
        this.groupToCentroid.clear();
    }

    @Override
    public void delete(String[] dataIds) throws IOException {
        for (String dataId : dataIds) {
            if (dataId == null) continue;
            QueryBuilder bldr = (QueryBuilder)QueryBuilder.newBuilder().addTypeName(this.centroidDataTypeId).indexName(this.index.getName());
            this.dataStore.delete((Query)((QueryBuilder)bldr.constraints(bldr.constraintsFactory().dataIds((byte[][])new byte[][]{StringUtils.stringToBinary((String)dataId)}))).build());
        }
    }

    @Override
    public List<String> getAllCentroidGroups() throws IOException {
        ArrayList<String> groups = new ArrayList<String>();
        CloseableIterator<T> it = this.getRawCentroids(this.batchId, null);
        while (it.hasNext()) {
            AnalyticItemWrapper<Object> item = this.centroidFactory.create(it.next());
            String groupID = item.getGroupID();
            int pos = groups.indexOf(groupID);
            if (pos < 0) {
                pos = groups.size();
                groups.add(groupID);
            }
            if (pos >= 100) continue;
            this.getCentroidsForGroup(groupID);
        }
        it.close();
        return groups;
    }

    @Override
    public List<AnalyticItemWrapper<T>> getCentroidsForGroup(String groupID) throws IOException {
        return this.getCentroidsForGroup(this.batchId, groupID);
    }

    @Override
    public List<AnalyticItemWrapper<T>> getCentroidsForGroup(String batchID, String groupID) throws IOException {
        String lookupGroup = groupID == null ? "##" : groupID;
        Pair gid = Pair.of((Object)batchID, (Object)lookupGroup);
        List<AnalyticItemWrapper<T>> centroids = (List<AnalyticItemWrapper<T>>)this.groupToCentroid.get((Object)gid);
        if (centroids == null) {
            centroids = groupID == null ? this.loadCentroids(batchID, null) : this.loadCentroids(batchID, groupID);
            this.groupToCentroid.put((Object)gid, centroids);
        }
        return centroids;
    }

    @Override
    public AnalyticItemWrapper<T> getCentroidById(String id, String groupID) throws IOException, MatchingCentroidNotFoundException {
        for (AnalyticItemWrapper<T> centroid : this.getCentroidsForGroup(groupID)) {
            if (!centroid.getID().equals(id)) continue;
            return centroid;
        }
        throw new MatchingCentroidNotFoundException(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AnalyticItemWrapper<T>> loadCentroids(String batchID, String groupID) throws IOException {
        ArrayList<AnalyticItemWrapper<T>> arrayList;
        block7: {
            ArrayList<AnalyticItemWrapper<T>> centroids = new ArrayList<AnalyticItemWrapper<T>>();
            CloseableIterator<T> it = null;
            try {
                it = this.getRawCentroids(batchID, groupID);
                while (it.hasNext()) {
                    centroids.add(this.centroidFactory.create(it.next()));
                }
                arrayList = centroids;
                if (it == null) break block7;
            }
            catch (Throwable throwable) {
                try {
                    if (it != null) {
                        it.close();
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error("Cannot load centroids");
                    throw new IOException(e);
                }
            }
            it.close();
        }
        return arrayList;
    }

    @Override
    public AnalyticItemWrapper<T> getCentroid(String dataId) {
        QueryBuilder bldr = (QueryBuilder)QueryBuilder.newBuilder().addTypeName(this.centroidDataTypeId).indexName(this.index.getName());
        try (CloseableIterator it = this.dataStore.query((Query)((QueryBuilder)bldr.constraints(bldr.constraintsFactory().dataIds((byte[][])new byte[][]{StringUtils.stringToBinary((String)dataId)}))).build());){
            if (it.hasNext()) {
                AnalyticItemWrapper<Object> analyticItemWrapper = this.centroidFactory.create(it.next());
                return analyticItemWrapper;
            }
        }
        return null;
    }

    protected CloseableIterator<T> getRawCentroids(String batchId, String groupID) throws IOException {
        PropertyName exp1;
        PropertyIsEqualTo batchIdFilter;
        FilterFactoryImpl factory = new FilterFactoryImpl();
        PropertyName expB1 = factory.property(AnalyticFeature.ClusterFeatureAttribute.BATCH_ID.attrName());
        Literal expB2 = factory.literal((Object)batchId);
        PropertyIsEqualTo finalFilter = batchIdFilter = factory.equal((Expression)expB1, (Expression)expB2, false);
        if (groupID != null) {
            exp1 = factory.property(AnalyticFeature.ClusterFeatureAttribute.GROUP_ID.attrName());
            Literal exp2 = factory.literal((Object)groupID);
            finalFilter = factory.and((Filter)factory.equal((Expression)exp1, (Expression)exp2, false), (Filter)batchIdFilter);
        } else if (this.level > 0) {
            exp1 = factory.property(AnalyticFeature.ClusterFeatureAttribute.ZOOM_LEVEL.attrName());
            Literal exp2 = factory.literal(this.level);
            finalFilter = factory.and((Filter)factory.equal((Expression)exp1, (Expression)exp2, false), (Filter)batchIdFilter);
        }
        VectorQueryBuilder bldr = (VectorQueryBuilder)((VectorQueryBuilder)VectorQueryBuilder.newBuilder().addTypeName(this.adapter.getTypeName())).indexName(this.index.getName());
        return this.dataStore.query((Query)((VectorQueryBuilder)bldr.constraints(bldr.constraintsFactory().filterConstraints((Filter)finalFilter))).build());
    }

    public void transferBatch(String fromBatchId, String groupID) throws IOException {
        int count = 0;
        try (CloseableIterator<T> it = this.getRawCentroids(fromBatchId, groupID);){
            this.dataStore.addType((DataTypeAdapter)this.adapter, new Index[]{this.index});
            try (Writer indexWriter = this.dataStore.createWriter(this.adapter.getTypeName());){
                while (it.hasNext()) {
                    AnalyticItemWrapper<Object> item = this.centroidFactory.create(it.next());
                    item.setBatchID(this.batchId);
                    ++count;
                    indexWriter.write(item.getWrappedItem());
                }
            }
        }
        LOGGER.info("Transfer " + count + " centroids");
    }

    @Override
    public int processForAllGroups(CentroidManager.CentroidProcessingFn<T> fn) throws IOException {
        String groupID;
        List<String> centroidGroups;
        try {
            centroidGroups = this.getAllCentroidGroups();
        }
        catch (IOException e) {
            throw new IOException(e);
        }
        int status = 0;
        Iterator<String> iterator = centroidGroups.iterator();
        while (iterator.hasNext() && (status = fn.processGroup(groupID = iterator.next(), this.getCentroidsForGroup(groupID))) == 0) {
        }
        return status;
    }

    public static Collection<ParameterEnum<?>> getParameters() {
        return Arrays.asList(MY_PARAMS);
    }

    public static void setParameters(Configuration config, Class<?> scope, PropertyManagement runTimeProperties) {
        runTimeProperties.setConfig(MY_PARAMS, config, scope);
    }

    @Override
    public String getIndexName() {
        return this.index.getName();
    }

    public String getBatchId() {
        return this.batchId;
    }

    private ToSimpleFeatureConverter<T> getFeatureConverter(List<AnalyticItemWrapper<T>> items, Class<? extends Geometry> shapeClass) {
        return this.adapter instanceof FeatureDataAdapter ? new SimpleFeatureConverter((FeatureDataAdapter)this.adapter, shapeClass) : new NonSimpleFeatureConverter(items.isEmpty() ? new String[]{} : items.get(0).getExtraDimensions(), shapeClass);
    }

    private static SimpleFeatureType createFeatureType(SimpleFeatureType featureType, Class<? extends Geometry> shapeClass) {
        try {
            SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
            builder.setName(featureType.getName().getLocalPart());
            builder.setNamespaceURI(featureType.getName().getNamespaceURI());
            builder.setCRS(featureType.getCoordinateReferenceSystem());
            for (AttributeDescriptor attr : featureType.getAttributeDescriptors()) {
                if (attr.getType() instanceof GeometryType) {
                    builder.add(attr.getLocalName(), shapeClass);
                    continue;
                }
                builder.add(attr.getLocalName(), attr.getType().getBinding());
            }
            return builder.buildFeatureType();
        }
        catch (Exception e) {
            LOGGER.warn("Schema Creation Error.  Hint: Check the SRID.", (Throwable)e);
            return null;
        }
    }

    private static Geometry convert(Geometry value, Class<? extends Geometry> shapeClass) {
        if (shapeClass.isInstance(value)) {
            return value;
        }
        if (shapeClass.isAssignableFrom(Point.class)) {
            return value.getCentroid();
        }
        Geometry hull = value.convexHull();
        if (shapeClass.isInstance(hull)) {
            return hull;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toShapeFile(String parentDir, Class<? extends Geometry> shapeClass) throws IOException {
        ShapefileDataStoreFactory dataStoreFactory = new ShapefileDataStoreFactory();
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        try {
            params.put("url", new URL("file://" + parentDir + "/" + this.batchId + ".shp"));
        }
        catch (MalformedURLException e) {
            LOGGER.error("Error creating URL", (Throwable)e);
        }
        params.put("create spatial index", Boolean.TRUE);
        List<AnalyticItemWrapper<T>> centroids = this.loadCentroids(this.batchId, null);
        ToSimpleFeatureConverter<T> converter = this.getFeatureConverter(centroids, shapeClass);
        ShapefileDataStore newDataStore = (ShapefileDataStore)dataStoreFactory.createNewDataStore(params);
        newDataStore.createSchema(converter.getFeatureType());
        DefaultTransaction transaction = new DefaultTransaction("create");
        String typeName = newDataStore.getTypeNames()[0];
        try (FeatureWriter writer = newDataStore.getFeatureWriterAppend(typeName, (Transaction)transaction);){
            for (AnalyticItemWrapper<T> item : centroids) {
                SimpleFeature copy = (SimpleFeature)writer.next();
                SimpleFeature newFeature = converter.toSimpleFeature(item);
                for (AttributeDescriptor attrD : newFeature.getFeatureType().getAttributeDescriptors()) {
                    if (copy.getFeatureType().getDescriptor(attrD.getName()) == null) continue;
                    copy.setAttribute(attrD.getName(), newFeature.getAttribute(attrD.getName()));
                }
                copy.setDefaultGeometry(newFeature.getDefaultGeometry());
                writer.write();
            }
        }
        catch (IOException e) {
            LOGGER.warn("Problem with the FeatureWritter", (Throwable)e);
            transaction.rollback();
        }
        finally {
            transaction.commit();
            transaction.close();
        }
    }

    @Override
    public String getDataTypeName() {
        return this.centroidDataTypeId;
    }

    private class NonSimpleFeatureConverter
    implements ToSimpleFeatureConverter<T> {
        final SimpleFeatureType featureType;
        final Object[] defaults;
        final Class<? extends Geometry> shapeClass;

        public NonSimpleFeatureConverter(String[] extraDimensionNames, Class<? extends Geometry> shapeClass) {
            this.featureType = AnalyticFeature.createFeatureAdapter(CentroidManagerGeoWave.this.centroidDataTypeId, extraDimensionNames, "http://www.opengis.net/gml", "EPSG:4326", AnalyticFeature.ClusterFeatureAttribute.values(), shapeClass).getFeatureType();
            this.shapeClass = shapeClass;
            List descriptors = this.featureType.getAttributeDescriptors();
            this.defaults = new Object[descriptors.size()];
            int p = 0;
            for (AttributeDescriptor descriptor : descriptors) {
                this.defaults[p++] = descriptor.getDefaultValue();
            }
        }

        @Override
        public SimpleFeatureType getFeatureType() {
            return this.featureType;
        }

        @Override
        public SimpleFeature toSimpleFeature(AnalyticItemWrapper<T> item) {
            Geometry value = item.getGeometry();
            Geometry newValue = CentroidManagerGeoWave.convert(value, this.shapeClass);
            if (newValue == null) {
                return null;
            }
            return AnalyticFeature.createGeometryFeature(this.featureType, item.getBatchID(), item.getID(), item.getName(), item.getGroupID(), item.getCost(), newValue, item.getExtraDimensions(), item.getDimensionValues(), item.getZoomLevel(), item.getIterationID(), item.getAssociationCount());
        }
    }

    private class SimpleFeatureConverter
    implements ToSimpleFeatureConverter<T> {
        final SimpleFeatureType type;
        final Object[] defaults;
        final Class<? extends Geometry> shapeClass;

        public SimpleFeatureConverter(FeatureDataAdapter adapter, Class<? extends Geometry> shapeClass) {
            this.type = CentroidManagerGeoWave.createFeatureType(adapter.getFeatureType(), shapeClass);
            int p = 0;
            this.shapeClass = shapeClass;
            List descriptors = adapter.getFeatureType().getAttributeDescriptors();
            this.defaults = new Object[descriptors.size()];
            for (AttributeDescriptor descriptor : descriptors) {
                this.defaults[p++] = descriptor.getDefaultValue();
            }
        }

        @Override
        public SimpleFeatureType getFeatureType() {
            return this.type;
        }

        @Override
        public SimpleFeature toSimpleFeature(AnalyticItemWrapper<T> item) {
            SimpleFeature newFeature = SimpleFeatureBuilder.build((SimpleFeatureType)this.type, (Object[])this.defaults, (String)item.getID());
            int i = 0;
            for (Object value : ((SimpleFeature)item.getWrappedItem()).getAttributes()) {
                if (value instanceof Geometry) {
                    Geometry newValue = CentroidManagerGeoWave.convert((Geometry)value, this.shapeClass);
                    if (newValue == null) {
                        return null;
                    }
                    newFeature.setAttribute(i++, (Object)newValue);
                    continue;
                }
                newFeature.setAttribute(i++, value);
            }
            return newFeature;
        }
    }

    private static interface ToSimpleFeatureConverter<T> {
        public SimpleFeatureType getFeatureType();

        public SimpleFeature toSimpleFeature(AnalyticItemWrapper<T> var1);
    }
}

