/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic;

import java.io.IOException;
import java.util.UUID;
import org.apache.hadoop.mapreduce.JobContext;
import org.locationtech.geowave.analytic.AnalyticFeature;
import org.locationtech.geowave.analytic.AnalyticItemWrapper;
import org.locationtech.geowave.analytic.AnalyticItemWrapperFactory;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;

public class SimpleFeatureItemWrapperFactory
implements AnalyticItemWrapperFactory<SimpleFeature> {
    @Override
    public AnalyticItemWrapper<SimpleFeature> create(SimpleFeature item) {
        return new SimpleFeatureAnalyticItemWrapper(item);
    }

    @Override
    public void initialize(JobContext context, Class<?> scope, Logger logger) throws IOException {
    }

    private static String getAttribute(SimpleFeature feature, String name) {
        Object att = feature.getAttribute(name);
        return att == null ? null : att.toString();
    }

    private static int getIntAttribute(SimpleFeature feature, String name, int defaultValue) {
        Object att = feature.getAttribute(name);
        return att == null ? defaultValue : (att instanceof Number ? ((Number)att).intValue() : Integer.parseInt(att.toString()));
    }

    @Override
    public AnalyticItemWrapper<SimpleFeature> createNextItem(SimpleFeature feature, String groupID, Coordinate coordinate, String[] extraNames, double[] extraValues) {
        Geometry geometry = (Geometry)feature.getAttribute(AnalyticFeature.ClusterFeatureAttribute.GEOMETRY.attrName());
        return new SimpleFeatureAnalyticItemWrapper(AnalyticFeature.createGeometryFeature(feature.getFeatureType(), feature.getAttribute(AnalyticFeature.ClusterFeatureAttribute.BATCH_ID.attrName()).toString(), UUID.randomUUID().toString(), SimpleFeatureItemWrapperFactory.getAttribute(feature, AnalyticFeature.ClusterFeatureAttribute.NAME.attrName()), groupID, (Double)feature.getAttribute(AnalyticFeature.ClusterFeatureAttribute.WEIGHT.attrName()), (Geometry)geometry.getFactory().createPoint(coordinate), extraNames, extraValues, (Integer)feature.getAttribute(AnalyticFeature.ClusterFeatureAttribute.ZOOM_LEVEL.attrName()), (Integer)feature.getAttribute(AnalyticFeature.ClusterFeatureAttribute.ITERATION.attrName()) + 1, (Long)feature.getAttribute(AnalyticFeature.ClusterFeatureAttribute.COUNT.attrName())));
    }

    public static class SimpleFeatureAnalyticItemWrapper
    implements AnalyticItemWrapper<SimpleFeature> {
        final SimpleFeature item;

        public SimpleFeatureAnalyticItemWrapper(SimpleFeature item) {
            this.item = item;
        }

        @Override
        public String getID() {
            return this.item.getID();
        }

        @Override
        public SimpleFeature getWrappedItem() {
            return this.item;
        }

        @Override
        public long getAssociationCount() {
            Long countO = (Long)this.item.getAttribute(AnalyticFeature.ClusterFeatureAttribute.COUNT.attrName());
            return countO != null ? countO : 0L;
        }

        @Override
        public int getIterationID() {
            return (Integer)this.item.getAttribute(AnalyticFeature.ClusterFeatureAttribute.ITERATION.attrName());
        }

        @Override
        public String getGroupID() {
            return SimpleFeatureItemWrapperFactory.getAttribute(this.item, AnalyticFeature.ClusterFeatureAttribute.GROUP_ID.attrName());
        }

        @Override
        public void setGroupID(String groupID) {
            this.item.setAttribute(AnalyticFeature.ClusterFeatureAttribute.GROUP_ID.attrName(), (Object)groupID);
        }

        @Override
        public void resetAssociatonCount() {
            this.item.setAttribute(AnalyticFeature.ClusterFeatureAttribute.COUNT.attrName(), (Object)0);
        }

        @Override
        public void incrementAssociationCount(long increment) {
            this.item.setAttribute(AnalyticFeature.ClusterFeatureAttribute.COUNT.attrName(), (Object)(this.getAssociationCount() + increment));
        }

        public String toString() {
            return "SimpleFeatureCentroid [item=" + this.item.getID() + ", + group=" + this.getGroupID() + ", + count=" + this.getAssociationCount() + ", cost=" + this.getCost() + "]";
        }

        @Override
        public double getCost() {
            Double costO = (Double)this.item.getAttribute(AnalyticFeature.ClusterFeatureAttribute.WEIGHT.attrName());
            return costO != null ? costO : 0.0;
        }

        @Override
        public void setCost(double cost) {
            this.item.setAttribute(AnalyticFeature.ClusterFeatureAttribute.WEIGHT.attrName(), (Object)cost);
        }

        @Override
        public String getName() {
            return this.item.getAttribute(AnalyticFeature.ClusterFeatureAttribute.NAME.attrName()).toString();
        }

        @Override
        public String[] getExtraDimensions() {
            return new String[0];
        }

        @Override
        public double[] getDimensionValues() {
            return new double[0];
        }

        @Override
        public Geometry getGeometry() {
            return (Geometry)this.item.getAttribute(AnalyticFeature.ClusterFeatureAttribute.GEOMETRY.attrName());
        }

        @Override
        public void setZoomLevel(int level) {
            this.item.setAttribute(AnalyticFeature.ClusterFeatureAttribute.ZOOM_LEVEL.attrName(), (Object)level);
        }

        @Override
        public int getZoomLevel() {
            return SimpleFeatureItemWrapperFactory.getIntAttribute(this.item, AnalyticFeature.ClusterFeatureAttribute.ZOOM_LEVEL.attrName(), 1);
        }

        @Override
        public void setBatchID(String batchID) {
            this.item.setAttribute(AnalyticFeature.ClusterFeatureAttribute.BATCH_ID.attrName(), (Object)batchID);
        }

        @Override
        public String getBatchID() {
            return this.item.getAttribute(AnalyticFeature.ClusterFeatureAttribute.BATCH_ID.attrName()).toString();
        }
    }
}

