/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.locationtech.geowave.core.store.adapter.TransientAdapterStore;
import org.locationtech.geowave.core.store.api.DataTypeAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializableAdapterStore
implements TransientAdapterStore,
Serializable {
    private static final long serialVersionUID = 1L;
    static final Logger LOGGER = LoggerFactory.getLogger(SerializableAdapterStore.class);
    transient TransientAdapterStore adapterStore;

    public SerializableAdapterStore() {
    }

    public SerializableAdapterStore(TransientAdapterStore adapterStore) {
        this.adapterStore = adapterStore;
    }

    private TransientAdapterStore getAdapterStore() {
        if (this.adapterStore == null) {
            throw new IllegalStateException("AdapterStore has not been initialized");
        }
        return this.adapterStore;
    }

    public void addAdapter(DataTypeAdapter<?> adapter) {
        this.getAdapterStore().addAdapter(adapter);
    }

    public DataTypeAdapter<?> getAdapter(String typeName) {
        return this.getAdapterStore().getAdapter((Object)typeName);
    }

    public boolean adapterExists(String typeName) {
        return this.getAdapterStore().adapterExists((Object)typeName);
    }

    public DataTypeAdapter<?>[] getAdapters() {
        return this.getAdapterStore().getAdapters();
    }

    public void removeAll() {
        this.getAdapterStore().removeAll();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.adapterStore instanceof Serializable) {
            out.writeBoolean(true);
            out.writeObject(this.adapterStore);
        } else {
            out.writeBoolean(false);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (in.readBoolean()) {
            this.adapterStore = (TransientAdapterStore)in.readObject();
        } else {
            LOGGER.warn("Unable to initialized AdapterStore; the store is not serializable");
        }
    }

    public void removeAdapter(String typeName) {
        this.getAdapterStore().removeAdapter((Object)typeName);
    }
}

