/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.locationtech.geowave.analytic.param.ParameterEnum;
import org.locationtech.geowave.core.index.ByteArrayUtils;
import org.locationtech.geowave.core.index.numeric.NumericRange;
import org.locationtech.geowave.core.index.persist.Persistable;
import org.locationtech.geowave.core.index.persist.PersistenceUtils;
import org.locationtech.geowave.core.store.api.Query;
import org.locationtech.geowave.core.store.api.QueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyManagement
implements Serializable {
    private static final long serialVersionUID = -4186468044516636362L;
    static final Logger LOGGER = LoggerFactory.getLogger(PropertyManagement.class);
    private final Map<ParameterEnum<?>, Serializable> localProperties = new HashMap();
    private final List<PropertyConverter<?>> converters = new ArrayList();
    private PropertyManagement nestProperties = null;

    public PropertyManagement() {
        this.converters.add(new QueryConverter());
        this.converters.add(new PathConverter());
        this.converters.add(new PersistableConverter());
        this.converters.add(new DoubleConverter());
        this.converters.add(new IntegerConverter());
        this.converters.add(new ByteConverter());
    }

    public PropertyManagement(PropertyConverter<?>[] converters, ParameterEnum<?>[] names, Object[] values) {
        this.converters.add(new QueryConverter());
        this.converters.add(new PathConverter());
        this.converters.add(new PersistableConverter());
        this.converters.add(new DoubleConverter());
        this.converters.add(new IntegerConverter());
        this.converters.add(new ByteConverter());
        for (PropertyConverter<?> converter : converters) {
            this.addConverter(converter);
        }
        this.storeAll(names, values);
    }

    public PropertyManagement(ParameterEnum<?>[] names, Object[] values) {
        this.converters.add(new QueryConverter());
        this.converters.add(new PathConverter());
        this.converters.add(new PersistableConverter());
        this.converters.add(new DoubleConverter());
        this.converters.add(new IntegerConverter());
        this.converters.add(new ByteConverter());
        this.storeAll(names, values);
    }

    public PropertyManagement(PropertyManagement pm) {
        this.nestProperties = pm;
        this.converters.addAll(pm.converters);
    }

    public Serializable get(ParameterEnum<?> propertyName) {
        return this.getPropertyValue(propertyName);
    }

    public synchronized <T> void store(ParameterEnum<?> property, T value, PropertyConverter<T> converter) {
        Serializable convertedValue;
        try {
            convertedValue = converter.convert(value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Cannot store %s with value %s. Expected type = %s; Error message = %s", property.self().toString(), value.toString(), property.getHelper().getBaseClass().toString(), e.getLocalizedMessage()), e);
        }
        this.localProperties.put(property, convertedValue);
        this.addConverter(converter);
    }

    public synchronized void store(ParameterEnum<?> property, Object value) {
        if (value != null) {
            Serializable convertedValue;
            try {
                convertedValue = this.convertIfNecessary(property, value);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Cannot store %s with value %s:%s", property.self().toString(), value.toString(), e.getLocalizedMessage()));
            }
            this.localProperties.put(property, convertedValue);
        }
    }

    public synchronized Serializable storeIfEmpty(ParameterEnum<?> propertyEnum, Serializable value) {
        if (!this.containsPropertyValue(propertyEnum) && value != null) {
            LOGGER.info("Setting parameter : {} to {}", (Object)propertyEnum.toString(), (Object)value.toString());
            this.store(propertyEnum, value);
            return value;
        }
        return this.getPropertyValue(propertyEnum);
    }

    public synchronized void copy(ParameterEnum<?> propertyNameFrom, ParameterEnum<?> propertyNameTo) {
        if (this.containsPropertyValue(propertyNameFrom)) {
            this.localProperties.put(propertyNameTo, this.getPropertyValue(propertyNameFrom));
        }
    }

    public synchronized void storeAll(ParameterEnum<?>[] names, Object[] values) {
        if (values.length != names.length) {
            LOGGER.error("The number of values must equal the number of names passed to the store method");
            throw new IllegalArgumentException("The number of values must equal the number of names passed to the store method");
        }
        int i = 0;
        for (Object value : values) {
            this.store(names[i++], value);
        }
    }

    public void setConfig(ParameterEnum<?>[] parameters, Configuration config, Class<?> scope) {
        for (ParameterEnum<?> param : parameters) {
            try {
                Object value = this.getProperty(param);
                param.getHelper().setValue(config, scope, value);
            }
            catch (Exception e) {
                LOGGER.error("Property " + param.self().toString() + " is not available", (Throwable)e);
                throw new IllegalArgumentException("Property " + param.self().toString() + " is not available", e);
            }
        }
    }

    public <T> T getClassInstance(ParameterEnum<?> property, Class<T> iface, Class<?> defaultClass) throws InstantiationException {
        Serializable o = this.getPropertyValue(property);
        try {
            Class<?> clazz;
            Class<?> clazz2 = o == null ? defaultClass : (clazz = o instanceof Class ? (Class<?>)o : Class.forName(o.toString()));
            if (!property.getHelper().getBaseClass().isAssignableFrom(clazz)) {
                LOGGER.error("Class for property " + property.self().toString() + " does not implement " + property.getHelper().getBaseClass().toString());
            }
            return (T)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Class for property " + property.self().toString() + " is not found", (Throwable)e);
            throw new InstantiationException(property.self().toString());
        }
        catch (InstantiationException e) {
            LOGGER.error("Class for property " + property.self().toString() + " is not instiatable", (Throwable)e);
            throw new InstantiationException(property.self().toString());
        }
        catch (IllegalAccessException e) {
            LOGGER.error("Class for property " + property.self().toString() + " is not accessible", (Throwable)e);
            throw new InstantiationException(property.self().toString());
        }
    }

    public synchronized boolean hasProperty(ParameterEnum<?> property) {
        return this.containsPropertyValue(property);
    }

    public String getPropertyAsString(ParameterEnum<?> property) {
        return this.getPropertyAsString(property, null);
    }

    public Object getProperty(ParameterEnum<?> property) throws Exception {
        Serializable value = this.getPropertyValue(property);
        if (!Serializable.class.isAssignableFrom(property.getHelper().getBaseClass())) {
            for (PropertyConverter<?> converter : this.converters) {
                if (!converter.baseClass().isAssignableFrom(property.getHelper().getBaseClass())) continue;
                return this.validate(property, converter.convert(value));
            }
        }
        return this.validate(property, value);
    }

    public <T> T getProperty(ParameterEnum<?> property, PropertyConverter<T> converter) throws Exception {
        Serializable value = this.getPropertyValue(property);
        return converter.convert(value);
    }

    public byte[] getPropertyAsBytes(ParameterEnum<?> property) {
        Serializable val = this.getPropertyValue(property);
        if (val != null) {
            if (val instanceof byte[]) {
                return (byte[])val;
            }
            return ByteArrayUtils.byteArrayFromString((String)val.toString());
        }
        return null;
    }

    public String getPropertyAsString(ParameterEnum<?> property, String defaultValue) {
        Serializable value = this.getPropertyValue(property);
        return (String)this.validate(property, value == null ? defaultValue : value.toString());
    }

    public Boolean getPropertyAsBoolean(ParameterEnum<?> property, Boolean defaultValue) {
        Serializable val = this.getPropertyValue(property);
        if (val != null) {
            return Boolean.valueOf(val.toString());
        }
        LOGGER.warn("Using default value for parameter : " + property.self().toString());
        return defaultValue;
    }

    public Integer getPropertyAsInt(ParameterEnum<?> property, int defaultValue) {
        Serializable val = this.getPropertyValue(property);
        if (val != null) {
            if (val instanceof Integer) {
                return (Integer)val;
            }
            return (Integer)this.validate(property, Integer.parseInt(val.toString()));
        }
        LOGGER.warn("Using default value for parameter : " + property.self().toString());
        return defaultValue;
    }

    public Double getPropertyAsDouble(ParameterEnum<?> property, double defaultValue) {
        Serializable val = this.getPropertyValue(property);
        if (val != null) {
            if (val instanceof Double) {
                return (Double)val;
            }
            return Double.parseDouble(val.toString());
        }
        LOGGER.warn("Using default value for parameter : " + property.self().toString());
        return defaultValue;
    }

    public NumericRange getPropertyAsRange(ParameterEnum<?> property, NumericRange defaultValue) {
        Serializable val = this.getPropertyValue(property);
        if (val != null) {
            if (val instanceof NumericRange) {
                return (NumericRange)val;
            }
            String p = val.toString();
            String[] parts = p.split(",");
            try {
                if (parts.length == 2) {
                    return new NumericRange(Double.parseDouble(parts[0].trim()), Double.parseDouble(parts[1].trim()));
                }
                return new NumericRange(0.0, Double.parseDouble(p));
            }
            catch (Exception ex) {
                LOGGER.error("Invalid range parameter " + property.self().toString(), (Throwable)ex);
                return defaultValue;
            }
        }
        LOGGER.warn("Using default value for parameter : " + property.self().toString());
        return defaultValue;
    }

    public Class<?> getPropertyAsClass(ParameterEnum<?> property) {
        Serializable val = this.getPropertyValue(property);
        if (val != null) {
            if (val instanceof Class) {
                return this.validate((Class)val, property.getHelper().getBaseClass());
            }
            try {
                return this.validate(Class.forName(val.toString()), property.getHelper().getBaseClass());
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("Class not found for property " + property, (Throwable)e);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.error("Invalid class for property" + property, (Throwable)ex);
                throw new IllegalArgumentException("Invalid class for property" + property);
            }
        }
        return null;
    }

    public <T> Class<T> getPropertyAsClass(ParameterEnum<?> property, Class<T> iface) throws ClassNotFoundException {
        Serializable val = this.getPropertyValue(property);
        if (val != null) {
            if (val instanceof Class) {
                return this.validate((Class)val, property.getHelper().getBaseClass());
            }
            try {
                return this.validate(Class.forName(val.toString()), property.getHelper().getBaseClass());
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("Class not found for property " + property.self().toString());
                throw e;
            }
            catch (IllegalArgumentException ex) {
                LOGGER.error("Invalid class for property" + property.self().toString(), (Throwable)ex);
                throw new IllegalArgumentException("Invalid class for property" + property);
            }
        }
        LOGGER.error("Value not found for property " + property.self().toString());
        throw new ClassNotFoundException("Value not found for property " + property.self().toString());
    }

    public <T> Class<? extends T> getPropertyAsClass(ParameterEnum<?> property, Class<? extends T> iface, Class<? extends T> defaultClass) {
        Serializable val = this.getPropertyValue(property);
        if (val != null) {
            if (val instanceof Class) {
                return this.validate((Class)val, property.getHelper().getBaseClass());
            }
            try {
                return this.validate(Class.forName(val.toString()), property.getHelper().getBaseClass());
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("Class not found for property " + property, (Throwable)e);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.error("Invalid class for property" + property, (Throwable)ex);
                throw new IllegalArgumentException("Invalid class for property" + property);
            }
        }
        LOGGER.warn("Using default class for parameter : " + property.self().toString());
        return defaultClass;
    }

    private <T> Class<T> validate(Class<T> classToValidate, Class<?> iface) throws IllegalArgumentException {
        if (!iface.isAssignableFrom(classToValidate)) {
            throw new IllegalArgumentException(classToValidate + "is an invalid subclass of " + iface);
        }
        return classToValidate;
    }

    public Query<?> getPropertyAsQuery(ParameterEnum property) throws Exception {
        Serializable val = this.getPropertyValue(property);
        if (val != null) {
            return (Query)this.validate(property, new QueryConverter().convert(val));
        }
        return null;
    }

    public Path getPropertyAsPath(ParameterEnum<?> property) throws Exception {
        Serializable val = this.getPropertyValue(property);
        if (val != null) {
            return (Path)this.validate(property, new PathConverter().convert(val));
        }
        return null;
    }

    public Persistable getPropertyAsPersistable(ParameterEnum<?> property) throws Exception {
        Serializable val = this.getPropertyValue(property);
        if (val != null) {
            return (Persistable)this.validate(property, new PersistableConverter().convert(val));
        }
        return null;
    }

    public void setJobConfiguration(Configuration configuration, Class<?> scope) {
        for (ParameterEnum<?> param : this.localProperties.keySet()) {
            param.getHelper().setValue(configuration, scope, param.getHelper().getValue(this));
        }
        if (this.nestProperties != null && !this.nestProperties.localProperties.isEmpty()) {
            this.nestProperties.setJobConfiguration(configuration, scope);
        }
    }

    public void dump() {
        LOGGER.info("Properties : ");
        for (Map.Entry<ParameterEnum<?>, Serializable> prop : this.localProperties.entrySet()) {
            LOGGER.info("{} = {}", prop.getKey(), (Object)prop.getValue());
        }
        this.nestProperties.dump();
    }

    public synchronized void addConverter(PropertyConverter<?> converter) {
        this.converters.add(converter);
    }

    private static byte[] toBytes(Persistable persistableObject) throws UnsupportedEncodingException {
        return PersistenceUtils.toBinary((Persistable)persistableObject);
    }

    private static Persistable fromBytes(byte[] data) throws InstantiationException, IllegalAccessException, ClassNotFoundException, UnsupportedEncodingException {
        return PersistenceUtils.fromBinary((byte[])data);
    }

    private Object validate(ParameterEnum propertyName, Object value) {
        if (value != null) {
            if (value instanceof Class) {
                if (((Class)value).isAssignableFrom(propertyName.getHelper().getBaseClass())) {
                    throw new IllegalArgumentException(String.format("%s does not accept class %s", propertyName.self().toString(), ((Class)value).getName()));
                }
            } else if (!propertyName.getHelper().getBaseClass().isInstance(value)) {
                throw new IllegalArgumentException(String.format("%s does not accept type %s", propertyName.self().toString(), value.getClass().getName()));
            }
        }
        return value;
    }

    private Serializable convertIfNecessary(ParameterEnum property, Object value) throws Exception {
        if (!(value instanceof Serializable)) {
            for (PropertyConverter<?> converter : this.converters) {
                if (!converter.baseClass().isAssignableFrom(property.getHelper().getBaseClass())) continue;
                return converter.convert(value);
            }
        }
        if (!property.getHelper().getBaseClass().isInstance(value) && value instanceof String) {
            for (PropertyConverter<?> converter : this.converters) {
                if (!converter.baseClass().isAssignableFrom(property.getHelper().getBaseClass())) continue;
                return converter.convert(converter.convert((Serializable)((Object)value.toString())));
            }
        }
        return (Serializable)value;
    }

    private boolean containsPropertyValue(ParameterEnum<?> property) {
        return this.nestProperties != null && this.nestProperties.containsPropertyValue(property) || this.localProperties.containsKey(property);
    }

    private Serializable getPropertyValue(ParameterEnum<?> property) {
        Serializable val;
        Serializable serializable = val = this.localProperties != null ? this.localProperties.get(property) : null;
        if (val == null) {
            return this.nestProperties != null ? this.nestProperties.getPropertyValue(property) : null;
        }
        return val;
    }

    public static class PersistableConverter
    implements PropertyConverter<Persistable> {
        private static final long serialVersionUID = 1L;

        @Override
        public Serializable convert(Persistable ob) {
            try {
                return PropertyManagement.toBytes(ob);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException(String.format("Cannot convert %s to a Persistable: %s", ob.toString(), e.getLocalizedMessage()));
            }
        }

        @Override
        public Persistable convert(Serializable ob) throws Exception {
            if (ob instanceof byte[]) {
                return PropertyManagement.fromBytes((byte[])ob);
            }
            throw new IllegalArgumentException(String.format("Cannot convert %s to Persistable", ob.toString()));
        }

        @Override
        public Class<Persistable> baseClass() {
            return Persistable.class;
        }
    }

    public static class DoubleConverter
    implements PropertyConverter<Double> {
        private static final long serialVersionUID = 1L;

        @Override
        public Serializable convert(Double ob) {
            return ob;
        }

        @Override
        public Double convert(Serializable ob) throws Exception {
            return Double.parseDouble(ob.toString());
        }

        @Override
        public Class<Double> baseClass() {
            return Double.class;
        }
    }

    public static class IntegerConverter
    implements PropertyConverter<Integer> {
        private static final long serialVersionUID = 1L;

        @Override
        public Serializable convert(Integer ob) {
            return ob;
        }

        @Override
        public Integer convert(Serializable ob) throws Exception {
            return Integer.parseInt(ob.toString());
        }

        @Override
        public Class<Integer> baseClass() {
            return Integer.class;
        }
    }

    public static class ByteConverter
    implements PropertyConverter<byte[]> {
        private static final long serialVersionUID = 1L;

        @Override
        public Serializable convert(byte[] ob) {
            return ByteArrayUtils.byteArrayToString((byte[])ob);
        }

        @Override
        public byte[] convert(Serializable ob) throws Exception {
            return ByteArrayUtils.byteArrayFromString((String)ob.toString());
        }

        @Override
        public Class<byte[]> baseClass() {
            return byte[].class;
        }
    }

    public static class PathConverter
    implements PropertyConverter<Path> {
        private static final long serialVersionUID = 1L;

        @Override
        public Serializable convert(Path ob) {
            return ob.toUri().toString();
        }

        @Override
        public Path convert(Serializable ob) throws Exception {
            return new Path(ob.toString());
        }

        @Override
        public Class<Path> baseClass() {
            return Path.class;
        }
    }

    public static class QueryConverter
    implements PropertyConverter<Query> {
        private static final long serialVersionUID = 1L;

        @Override
        public Serializable convert(Query ob) {
            try {
                return PropertyManagement.toBytes((Persistable)ob);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException(String.format("Cannot convert %s to a Query: %s", ob.toString(), e.getLocalizedMessage()));
            }
        }

        @Override
        public Query convert(Serializable ob) throws Exception {
            if (ob instanceof byte[]) {
                return (Query)PropertyManagement.fromBytes((byte[])ob);
            }
            if (ob instanceof Query) {
                return (Query)ob;
            }
            return (Query)QueryBuilder.newBuilder().build();
        }

        @Override
        public Class<Query> baseClass() {
            return Query.class;
        }
    }

    public static interface PropertyGroup<T extends Serializable>
    extends Serializable {
        public T convert(CommandLine var1) throws ParseException;

        public ParameterEnum getParameter();
    }

    public static interface PropertyConverter<T>
    extends Serializable {
        public Serializable convert(T var1) throws Exception;

        public T convert(Serializable var1) throws Exception;

        public Class<T> baseClass();
    }
}

