/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.math.util.MathUtils;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import org.locationtech.geowave.analytic.clustering.NeighborData;
import org.locationtech.geowave.analytic.distance.DistanceFn;
import org.locationtech.geowave.core.index.FloatCompareUtils;
import org.locationtech.jts.algorithm.CGAlgorithms;
import org.locationtech.jts.algorithm.ConvexHull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.operation.union.UnaryUnionOp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeometryHullTool {
    protected static final Logger LOGGER = LoggerFactory.getLogger(GeometryHullTool.class);
    DistanceFn<Coordinate> distanceFnForCoordinate;
    double concaveThreshold = 1.8;

    public void connect(List<Geometry> geometries) {
    }

    public DistanceFn<Coordinate> getDistanceFnForCoordinate() {
        return this.distanceFnForCoordinate;
    }

    public void setDistanceFnForCoordinate(DistanceFn<Coordinate> distanceFnForCoordinate) {
        this.distanceFnForCoordinate = distanceFnForCoordinate;
    }

    protected double getConcaveThreshold() {
        return this.concaveThreshold;
    }

    protected void setConcaveThreshold(double concaveThreshold) {
        this.concaveThreshold = concaveThreshold;
    }

    private Edge createEdgeWithSideEffects(Coordinate start, Coordinate end, Set<Coordinate> innerPoints, TreeSet<Edge> edges) {
        Edge newEdge = new Edge(start, end, this.distanceFnForCoordinate.measure(start, end));
        innerPoints.remove(newEdge.start);
        innerPoints.remove(newEdge.end);
        edges.add(newEdge);
        return newEdge;
    }

    public Geometry createHullFromGeometry(Geometry clusterGeometry, Collection<Coordinate> additionalPoints, boolean fast) {
        if (additionalPoints.isEmpty()) {
            return clusterGeometry;
        }
        HashSet<Coordinate> batchCoords = new HashSet<Coordinate>();
        if (clusterGeometry != null) {
            for (Coordinate coordinate : clusterGeometry.getCoordinates()) {
                batchCoords.add(coordinate);
            }
        }
        for (Coordinate coordinate : additionalPoints) {
            batchCoords.add(coordinate);
        }
        GeometryFactory factory = clusterGeometry == null ? new GeometryFactory() : clusterGeometry.getFactory();
        Coordinate[] actualCoords = batchCoords.toArray(new Coordinate[batchCoords.size()]);
        if (batchCoords.size() == 2) {
            return factory.createLineString(actualCoords);
        }
        ConvexHull convexHull = new ConvexHull(actualCoords, factory);
        Geometry convexHullGeo = convexHull.getConvexHull();
        try {
            if (batchCoords.size() > 5 && convexHullGeo.getArea() > 0.0) {
                Geometry concaveHull;
                Geometry geometry = concaveHull = fast ? this.concaveHull(convexHullGeo, batchCoords) : this.concaveHullParkOhMethod(convexHullGeo, batchCoords);
                if (fast && !concaveHull.isSimple()) {
                    LOGGER.warn("Produced non simple hull", (Object)concaveHull.toText());
                    return this.concaveHullParkOhMethod(convexHullGeo, batchCoords);
                }
                return concaveHull;
            }
            return convexHullGeo;
        }
        catch (Exception ex) {
            LOGGER.error("Failed to compute hull", (Throwable)ex);
            return convexHullGeo;
        }
    }

    public Geometry concaveHullParkOhMethod(Geometry geometry, Collection<Coordinate> providedInnerPoints) {
        Edge firstEdge;
        HashSet<Coordinate> innerPoints = new HashSet<Coordinate>(providedInnerPoints);
        TreeSet<Edge> edges = new TreeSet<Edge>();
        Coordinate[] geoCoordinateList = geometry.getCoordinates();
        int s = geoCoordinateList.length - 1;
        Edge lastEdge = firstEdge = this.createEdgeWithSideEffects(geoCoordinateList[0], geoCoordinateList[1], innerPoints, edges);
        for (int i = 1; i < s; ++i) {
            Edge newEdge = this.createEdgeWithSideEffects(geoCoordinateList[i], geoCoordinateList[i + 1], innerPoints, edges);
            newEdge.connectLast(lastEdge);
            lastEdge = newEdge;
        }
        firstEdge.connectLast(lastEdge);
        while (!edges.isEmpty() && !innerPoints.isEmpty()) {
            double endToCandidate;
            Edge edge;
            lastEdge = edge = edges.pollLast();
            double score = Double.MAX_VALUE;
            Coordinate selectedCandidate = null;
            for (Coordinate candidate : innerPoints) {
                double dist = GeometryHullTool.calcDistance(edge.start, edge.end, candidate);
                if (MathUtils.equals((double)dist, (double)0.0, (double)1.0E-9)) {
                    score = 0.0;
                    selectedCandidate = candidate;
                    break;
                }
                if (!(dist > 0.0) || !(dist < score)) continue;
                score = dist;
                selectedCandidate = candidate;
            }
            if (selectedCandidate == null) continue;
            if (FloatCompareUtils.checkDoublesEqual((double)score, (double)0.0)) {
                innerPoints.remove(selectedCandidate);
                edges.add(edge);
                continue;
            }
            if (GeometryHullTool.isCandidateCloserToAnotherEdge(score, edge, edges, selectedCandidate)) continue;
            innerPoints.remove(selectedCandidate);
            double eh = edge.distance;
            double startToCandidate = this.distanceFnForCoordinate.measure(edge.start, selectedCandidate);
            double min = Math.min(startToCandidate, endToCandidate = this.distanceFnForCoordinate.measure(edge.end, selectedCandidate));
            if (!(eh / min > this.concaveThreshold)) continue;
            Edge newEdge1 = new Edge(edge.start, selectedCandidate, startToCandidate);
            Edge newEdge2 = new Edge(selectedCandidate, edge.end, endToCandidate);
            if (GeometryHullTool.intersectAnotherEdge(newEdge1, edge) || GeometryHullTool.intersectAnotherEdge(newEdge2, edge) || GeometryHullTool.intersectAnotherEdge(newEdge1, edge.last) || GeometryHullTool.intersectAnotherEdge(newEdge2, edge.next)) continue;
            edges.add(newEdge2);
            edges.add(newEdge1);
            newEdge1.connectLast(edge.last);
            newEdge2.connectLast(newEdge1);
            edge.next.connectLast(newEdge2);
            lastEdge = newEdge1;
        }
        return geometry.getFactory().createPolygon(GeometryHullTool.reassemble(lastEdge));
    }

    public Geometry concaveHull(Geometry geometry, Collection<Coordinate> providedInnerPoints) {
        Edge firstEdge;
        Set<Object> innerPoints = providedInnerPoints instanceof Set ? (Set<Object>)providedInnerPoints : new HashSet<Coordinate>(providedInnerPoints);
        TreeSet<Edge> edges = new TreeSet<Edge>();
        Coordinate[] geoCoordinateList = geometry.getCoordinates();
        int s = geoCoordinateList.length - 1;
        Edge lastEdge = firstEdge = this.createEdgeWithSideEffects(geoCoordinateList[0], geoCoordinateList[1], (Set<Coordinate>)innerPoints, edges);
        for (int i = 1; i < s; ++i) {
            Edge newEdge = this.createEdgeWithSideEffects(geoCoordinateList[i], geoCoordinateList[i + 1], (Set<Coordinate>)innerPoints, edges);
            newEdge.connectLast(lastEdge);
            lastEdge = newEdge;
        }
        firstEdge.connectLast(lastEdge);
        for (Object candidate : innerPoints) {
            double min = Double.MAX_VALUE;
            Edge bestEdge = null;
            for (Edge edge : edges) {
                double dist = GeometryHullTool.calcDistance(edge.start, edge.end, (Coordinate)candidate);
                if (!(dist > 0.0) || !(dist < min)) continue;
                min = dist;
                bestEdge = edge;
            }
            if (bestEdge == null) continue;
            bestEdge.getPoints().add(new NeighborData<Object>(candidate, null, min));
        }
        while (!edges.isEmpty()) {
            Edge edge;
            Object candidate;
            lastEdge = edge = edges.pollLast();
            candidate = edge.getPoints().pollFirst();
            while (candidate != null) {
                double endToCandidate;
                Coordinate selectedCandidate;
                double startToCandidate;
                double min;
                double eh;
                if (!MathUtils.equals((double)((NeighborData)candidate).getDistance(), (double)0.0, (double)1.0E-9) && (eh = edge.distance) / (min = Math.min(startToCandidate = this.distanceFnForCoordinate.measure(edge.start, selectedCandidate = (Coordinate)((NeighborData)candidate).getElement()), endToCandidate = this.distanceFnForCoordinate.measure(edge.end, selectedCandidate))) > this.concaveThreshold) {
                    Edge newEdge1 = new Edge(edge.start, selectedCandidate, startToCandidate);
                    Edge newEdge2 = new Edge(selectedCandidate, edge.end, endToCandidate);
                    edges.add(newEdge2);
                    edges.add(newEdge1);
                    newEdge1.connectLast(edge.last);
                    newEdge2.connectLast(newEdge1);
                    edge.next.connectLast(newEdge2);
                    lastEdge = newEdge1;
                    for (NeighborData<Coordinate> otherPoint : edge.getPoints()) {
                        double[] distProfile1 = GeometryHullTool.calcDistanceSegment(newEdge1.start, newEdge1.end, otherPoint.getElement());
                        double[] distProfile2 = GeometryHullTool.calcDistanceSegment(newEdge2.start, newEdge2.end, otherPoint.getElement());
                        if (distProfile1[0] >= 0.0 && distProfile1[0] <= 1.0) {
                            if (distProfile1[0] < 0.0 || distProfile1[0] > 1.0 || distProfile2[1] > distProfile1[1]) {
                                otherPoint.setDistance(distProfile1[1]);
                                newEdge1.getPoints().add(otherPoint);
                                continue;
                            }
                            otherPoint.setDistance(distProfile2[1]);
                            newEdge2.getPoints().add(otherPoint);
                            continue;
                        }
                        if (!(distProfile2[0] >= 0.0) || !(distProfile2[0] <= 1.0)) continue;
                        otherPoint.setDistance(distProfile2[1]);
                        newEdge2.getPoints().add(otherPoint);
                    }
                    edge.getPoints().clear();
                }
                candidate = edge.getPoints().pollFirst();
            }
        }
        return geometry.getFactory().createPolygon(GeometryHullTool.reassemble(lastEdge));
    }

    public static boolean intersectAnotherEdge(Edge newEdge, Edge edgeToReplace) {
        Edge nextEdge = edgeToReplace.next.next;
        Edge stopEdge = edgeToReplace.last;
        while (nextEdge != stopEdge) {
            if (GeometryHullTool.edgesIntersect(newEdge, nextEdge)) {
                return true;
            }
            nextEdge = nextEdge.next;
        }
        return false;
    }

    public static boolean edgesIntersect(Edge e1, Edge e2) {
        return CGAlgorithms.distanceLineLine((Coordinate)e1.start, (Coordinate)e1.end, (Coordinate)e2.start, (Coordinate)e2.end) <= 0.0;
    }

    private static boolean isCandidateCloserToAnotherEdge(double distanceToBeat, Edge selectedEdgeToBeat, Collection<Edge> edges, Coordinate selectedCandidate) {
        for (Edge edge : edges) {
            double dist;
            if (selectedEdgeToBeat.equals(edge) || !((dist = GeometryHullTool.calcDistance(edge.start, edge.end, selectedCandidate)) >= 0.0) || !(dist < distanceToBeat)) continue;
            return true;
        }
        return false;
    }

    private static Coordinate[] reassemble(Edge lastEdge) {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        coordinates.add(lastEdge.start);
        Edge nextEdge = lastEdge.next;
        while (nextEdge != lastEdge) {
            coordinates.add(nextEdge.start);
            nextEdge = nextEdge.next;
        }
        coordinates.add(lastEdge.start);
        return coordinates.toArray(new Coordinate[coordinates.size()]);
    }

    protected boolean isInside(Coordinate coor, Coordinate[] hullCoordinates) {
        double maxAngle = 0.0;
        for (int i = 1; i < hullCoordinates.length; ++i) {
            Coordinate hullCoordinate = hullCoordinates[i];
            maxAngle = Math.max(GeometryHullTool.calcAngle(hullCoordinates[0], coor, hullCoordinate), maxAngle);
        }
        return Math.abs(maxAngle) >= 359.999 && Math.abs(maxAngle) <= 360.0001;
    }

    public Geometry connect(Geometry shape1, Geometry shape2) {
        try {
            if (shape1 instanceof Polygon && shape2 instanceof Polygon && !shape1.intersects(shape2)) {
                return this.connect(shape1, shape2, GeometryHullTool.getClosestPoints(shape1, shape2, this.distanceFnForCoordinate));
            }
            return UnaryUnionOp.union(Arrays.asList(shape1, shape2));
        }
        catch (Exception ex) {
            LOGGER.warn("Exception caught in connect method", (Throwable)ex);
            return this.createHullFromGeometry(shape1, Arrays.asList(shape2.getCoordinates()), false);
        }
    }

    protected Geometry connect(Geometry shape1, Geometry shape2, Pair<Integer, Integer> closestCoordinates) {
        int startRight;
        int startLeft;
        Coordinate[] leftCoords = shape1.getCoordinates();
        Coordinate[] rightCoords = shape2.getCoordinates();
        if (leftCoords[((Integer)closestCoordinates.getLeft()).intValue()].x < rightCoords[((Integer)closestCoordinates.getRight()).intValue()].x) {
            startLeft = (Integer)closestCoordinates.getLeft();
            startRight = (Integer)closestCoordinates.getRight();
        } else {
            leftCoords = shape2.getCoordinates();
            rightCoords = shape1.getCoordinates();
            startLeft = (Integer)closestCoordinates.getRight();
            startRight = (Integer)closestCoordinates.getLeft();
        }
        HashSet<Coordinate> visitedSet = new HashSet<Coordinate>();
        visitedSet.add(leftCoords[startLeft]);
        visitedSet.add(rightCoords[startRight]);
        final boolean leftClockwise = GeometryHullTool.clockwise(leftCoords);
        final boolean rightClockwise = GeometryHullTool.clockwise(rightCoords);
        Pair<Integer, Integer> upperCoords = this.walk(visitedSet, leftCoords, rightCoords, startLeft, startRight, new DirectionFactory(){

            @Override
            public Direction createLeftFootDirection(int start, int max) {
                return leftClockwise ? new IncreaseDirection(start, max, true) : new DecreaseDirection(start, max, true);
            }

            @Override
            public Direction createRightFootDirection(int start, int max) {
                return rightClockwise ? new DecreaseDirection(start, max, false) : new IncreaseDirection(start, max, false);
            }
        });
        Pair<Integer, Integer> lowerCoords = this.walk(visitedSet, leftCoords, rightCoords, startLeft, startRight, new DirectionFactory(){

            @Override
            public Direction createLeftFootDirection(int start, int max) {
                return leftClockwise ? new DecreaseDirection(start, max, false) : new IncreaseDirection(start, max, false);
            }

            @Override
            public Direction createRightFootDirection(int start, int max) {
                return rightClockwise ? new IncreaseDirection(start, max, true) : new DecreaseDirection(start, max, true);
            }
        });
        ArrayList<Coordinate> newCoordinateSet = new ArrayList<Coordinate>();
        IncreaseDirection leftSet = leftClockwise ? new IncreaseDirection((int)((Integer)upperCoords.getLeft()), (Integer)lowerCoords.getLeft() + 1, leftCoords.length) : new DecreaseDirection((int)((Integer)upperCoords.getLeft()), (Integer)lowerCoords.getLeft() - 1, leftCoords.length);
        newCoordinateSet.add(leftCoords[(Integer)upperCoords.getLeft()]);
        while (leftSet.hasNext()) {
            newCoordinateSet.add(leftCoords[(Integer)leftSet.next()]);
        }
        IncreaseDirection rightSet = rightClockwise ? new IncreaseDirection((int)((Integer)lowerCoords.getRight()), (Integer)upperCoords.getRight() + 1, rightCoords.length) : new DecreaseDirection((int)((Integer)lowerCoords.getRight()), (Integer)upperCoords.getRight() - 1, rightCoords.length);
        newCoordinateSet.add(rightCoords[(Integer)lowerCoords.getRight()]);
        while (rightSet.hasNext()) {
            newCoordinateSet.add(rightCoords[(Integer)rightSet.next()]);
        }
        newCoordinateSet.add(leftCoords[(Integer)upperCoords.getLeft()]);
        return shape1.getFactory().createPolygon(newCoordinateSet.toArray(new Coordinate[newCoordinateSet.size()]));
    }

    private Pair<Integer, Integer> walk(Set<Coordinate> visited, Coordinate[] shape1Coords, Coordinate[] shape2Coords, int start1, int start2, DirectionFactory factory) {
        int upPos = this.takeBiggestStep(visited, shape2Coords[start2], shape1Coords, factory.createLeftFootDirection(start1, shape1Coords.length));
        int downPos = this.takeBiggestStep(visited, shape1Coords[upPos], shape2Coords, factory.createRightFootDirection(start2, shape2Coords.length));
        if (downPos != start2) {
            return this.walk(visited, shape1Coords, shape2Coords, upPos, downPos, factory);
        }
        return Pair.of((Object)upPos, (Object)start2);
    }

    public static boolean clockwise(Coordinate[] set) {
        double sum = 0.0;
        for (int i = 1; i < set.length; ++i) {
            sum += (set[i].x - set[i - 1].x) / (set[i].y + set[i - 1].y);
        }
        return sum > 0.0;
    }

    public static double calcSmallestAngle(Coordinate one, Coordinate vertex, Coordinate two) {
        double angle = Math.abs(GeometryHullTool.calcAngle(one, vertex, two));
        return angle > 180.0 ? angle - 180.0 : angle;
    }

    public static double calcAngle(Coordinate one, Coordinate vertex, Coordinate two) {
        double p1x = one.x - vertex.x;
        double p1y = one.y - vertex.y;
        double p2x = two.x - vertex.x;
        double p2y = two.y - vertex.y;
        double angle1 = Math.toDegrees(Math.atan2(p1y, p1x));
        double angle2 = Math.toDegrees(Math.atan2(p2y, p2x));
        return angle2 - angle1;
    }

    public static double[] calcDistanceSegment(Coordinate start, Coordinate end, Coordinate point) {
        Vector2D vOne = new Vector2D(start.x, start.y);
        Vector2D vTwo = new Vector2D(end.x, end.y);
        Vector2D vVertex = new Vector2D(point.x, point.y);
        Vector E1 = vTwo.subtract((Vector)vOne);
        Vector E2 = vVertex.subtract((Vector)vOne);
        double distOneTwo = E2.dotProduct(E1);
        double lengthVOneSq = E1.getNormSq();
        double projectionLength = distOneTwo / lengthVOneSq;
        Vector projection = E1.scalarMultiply(projectionLength).add((Vector)vOne);
        double o = projectionLength < 0.0 ? vOne.distance((Vector)vVertex) : (projectionLength > 1.0 ? vTwo.distance((Vector)vVertex) : vVertex.distance(projection));
        return new double[]{projectionLength, o, vVertex.distance(projection)};
    }

    public static double calcDistance(Coordinate start, Coordinate end, Coordinate point) {
        double[] p = GeometryHullTool.calcDistanceSegment(start, end, point);
        return p[0] < 0.0 || p[0] > 1.0 ? -1.0 : p[1];
    }

    public static Pair<Integer, Integer> getClosestPoints(Geometry shape1, Geometry shape2, DistanceFn<Coordinate> distanceFnForCoordinate) {
        int bestShape1Position = 0;
        int bestShape2Position = 0;
        double minDist = Double.MAX_VALUE;
        int pos1 = 0;
        int pos2 = 0;
        for (Coordinate coord1 : shape1.getCoordinates()) {
            pos2 = 0;
            for (Coordinate coord2 : shape2.getCoordinates()) {
                double dist = distanceFnForCoordinate.measure(coord1, coord2);
                if (dist < minDist) {
                    bestShape1Position = pos1;
                    bestShape2Position = pos2;
                    minDist = dist;
                }
                ++pos2;
            }
            ++pos1;
        }
        return Pair.of((Object)bestShape1Position, (Object)bestShape2Position);
    }

    private int takeBiggestStep(Set<Coordinate> visited, Coordinate station, Coordinate[] shapeCoords, Direction legIncrement) {
        double angle = 0.0;
        Coordinate startPoint = shapeCoords[legIncrement.getStart()];
        int last = legIncrement.getStart();
        Coordinate lastCoordinate = shapeCoords[last];
        while (legIncrement.hasNext()) {
            int pos = (Integer)legIncrement.next();
            if (shapeCoords[pos].equals((Object)lastCoordinate)) continue;
            lastCoordinate = shapeCoords[pos];
            if (visited.contains(lastCoordinate)) break;
            double currentAngle = legIncrement.angleChange(GeometryHullTool.calcAngle(startPoint, station, lastCoordinate));
            double d = currentAngle = currentAngle < -180.0 ? currentAngle + 360.0 : currentAngle;
            if (currentAngle >= angle && currentAngle < 180.0) {
                angle = currentAngle;
                last = pos;
                visited.add(shapeCoords[pos]);
                continue;
            }
            return last;
        }
        return last;
    }

    private class DecreaseDirection
    extends IncreaseDirection
    implements Direction {
        public DecreaseDirection(int start, int max, boolean angleIsNegative) {
            super(start, max, angleIsNegative);
        }

        public DecreaseDirection(int start, int stop, int max) {
            super(start, stop, max);
        }

        @Override
        protected int getNext(int n) {
            return n == 0 ? this.max - 1 : n - 1;
        }
    }

    private class IncreaseDirection
    implements Direction {
        final int max;
        final int start;
        final int stop;
        int current = 0;
        final boolean angleIsNegative;

        @Override
        public int getStart() {
            return this.start;
        }

        public IncreaseDirection(int start, int max, boolean angleIsNegative) {
            this.max = max;
            this.current = this.getNext(start);
            this.stop = start;
            this.start = start;
            this.angleIsNegative = angleIsNegative;
        }

        public IncreaseDirection(int start, int stop, int max) {
            this.max = max;
            this.current = this.getNext(start);
            this.stop = stop;
            this.start = start;
            this.angleIsNegative = true;
        }

        @Override
        public Integer next() {
            int n = this.current;
            this.current = this.getNext(this.current);
            return n;
        }

        @Override
        public boolean hasNext() {
            return this.current != this.stop;
        }

        protected int getNext(int n) {
            return (n + 1) % this.max;
        }

        @Override
        public void remove() {
        }

        @Override
        public double angleChange(double angle) {
            return this.angleIsNegative ? -angle : angle;
        }
    }

    private static interface Direction
    extends Iterator<Integer> {
        public int getStart();

        public double angleChange(double var1);
    }

    private static interface DirectionFactory {
        public Direction createLeftFootDirection(int var1, int var2);

        public Direction createRightFootDirection(int var1, int var2);
    }

    protected static class Edge
    implements Comparable<Edge> {
        Coordinate start;
        Coordinate end;
        double distance;
        Edge next;
        Edge last;
        private TreeSet<NeighborData<Coordinate>> points = null;

        public Edge(Coordinate start, Coordinate end, double distance) {
            this.start = start;
            this.end = end;
            this.distance = distance;
        }

        public TreeSet<NeighborData<Coordinate>> getPoints() {
            if (this.points == null) {
                this.points = new TreeSet();
            }
            return this.points;
        }

        @Override
        public int compareTo(Edge edge) {
            return this.distance - edge.distance > 0.0 ? 1 : -1;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.end == null ? 0 : this.end.hashCode());
            result = 31 * result + (this.start == null ? 0 : this.start.hashCode());
            return result;
        }

        public void connectLast(Edge last) {
            this.last = last;
            last.next = this;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Edge other = (Edge)obj;
            if (this.end == null ? other.end != null : !this.end.equals((Object)other.end)) {
                return false;
            }
            return !(this.start == null ? other.start != null : !this.start.equals((Object)other.start));
        }

        public String toString() {
            return "Edge [start=" + this.start + ", end=" + this.end + ", distance=" + this.distance + "]";
        }
    }
}

