/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic;

import java.util.LinkedList;
import java.util.List;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.GeodeticCalculator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.units.indriya.unit.Units;

public class GeometryCalculations {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeometryCalculations.class);
    final GeometryFactory factory = new GeometryFactory(new PrecisionModel(), 4326);
    final CoordinateReferenceSystem crs;
    final double xMin;
    final double yMin;
    final double xMax;
    final double yMax;

    public GeometryCalculations(CoordinateReferenceSystem crs) {
        this.crs = crs;
        this.xMin = crs.getCoordinateSystem().getAxis(0).getMinimumValue();
        this.xMax = crs.getCoordinateSystem().getAxis(0).getMaximumValue();
        this.yMin = crs.getCoordinateSystem().getAxis(1).getMinimumValue();
        this.yMax = crs.getCoordinateSystem().getAxis(1).getMaximumValue();
    }

    public List<Geometry> buildSurroundingGeometries(double[] distances, Unit<Length> unit, Coordinate coordinate) {
        LinkedList<Geometry> geos = new LinkedList<Geometry>();
        GeodeticCalculator geoCalc = new GeodeticCalculator();
        geoCalc.setStartingGeographicPoint(coordinate.x, coordinate.y);
        try {
            geoCalc.setDirection(0.0, unit.getConverterTo(Units.METRE).convert(distances[1]));
            DirectPosition north = geoCalc.getDestinationPosition();
            geoCalc.setDirection(90.0, unit.getConverterTo(Units.METRE).convert(distances[0]));
            DirectPosition east = geoCalc.getDestinationPosition();
            geoCalc.setStartingGeographicPoint(coordinate.x, coordinate.y);
            geoCalc.setDirection(-90.0, unit.getConverterTo(Units.METRE).convert(distances[0]));
            DirectPosition west = geoCalc.getDestinationPosition();
            geoCalc.setDirection(180.0, unit.getConverterTo(Units.METRE).convert(distances[1]));
            DirectPosition south = geoCalc.getDestinationPosition();
            double x1 = west.getOrdinate(0);
            double x2 = east.getOrdinate(0);
            double y1 = north.getOrdinate(1);
            double y2 = south.getOrdinate(1);
            this.handleBoundaries(geos, coordinate, x1, x2, y1, y2);
            return geos;
        }
        catch (TransformException ex) {
            LOGGER.error("Unable to build geometry", (Throwable)ex);
            return null;
        }
    }

    private void handleBoundaries(List<Geometry> geos, Coordinate coordinate, double x1, double x2, double y1, double y2) {
        if (Math.signum(x1) > Math.signum(coordinate.x)) {
            ReferencedEnvelope bounds = new ReferencedEnvelope(x1, this.xMax, Math.max(y1, this.yMin), Math.min(y2, this.yMax), this.crs);
            geos.add(this.factory.toGeometry((Envelope)bounds));
            bounds = new ReferencedEnvelope(this.xMin, x2, Math.max(y1, this.yMin), Math.min(y2, this.yMax), this.crs);
            geos.add(this.factory.toGeometry((Envelope)bounds));
        } else if (Math.signum(x2) < Math.signum(coordinate.x)) {
            ReferencedEnvelope bounds = new ReferencedEnvelope(this.xMin, x2, Math.max(y1, this.yMin), Math.min(y2, this.yMax), this.crs);
            geos.add(this.factory.toGeometry((Envelope)bounds));
            bounds = new ReferencedEnvelope(x1, this.xMax, Math.max(y1, this.yMin), Math.min(y2, this.yMax), this.crs);
            geos.add(this.factory.toGeometry((Envelope)bounds));
        } else {
            ReferencedEnvelope bounds = new ReferencedEnvelope(x1, x2, Math.max(y1, this.yMin), Math.min(y2, this.yMax), this.crs);
            geos.add(this.factory.toGeometry((Envelope)bounds));
        }
    }
}

