/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic;

import java.util.List;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.CRS;
import org.locationtech.geowave.adapter.vector.FeatureDataAdapter;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyticFeature {
    static final Logger LOGGER = LoggerFactory.getLogger(AnalyticFeature.class);

    public static SimpleFeature createGeometryFeature(SimpleFeatureType featureType, String batchId, String dataId, String name, String groupID, double weight, Geometry geometry, String[] extraDimensionNames, double[] extraDimensions, int zoomLevel, int iteration, long count) {
        if (extraDimensionNames.length != extraDimensions.length) {
            LOGGER.error("The number of extraDimension names does not equal the number of extraDimensions");
            throw new IllegalArgumentException("The number of extraDimension names does not equal the number of extraDimensions");
        }
        List descriptors = featureType.getAttributeDescriptors();
        Object[] defaults = new Object[descriptors.size()];
        int p = 0;
        for (AttributeDescriptor descriptor : descriptors) {
            defaults[p++] = descriptor.getDefaultValue();
        }
        SimpleFeature newFeature = SimpleFeatureBuilder.build((SimpleFeatureType)featureType, (Object[])defaults, (String)dataId);
        newFeature.setAttribute(ClusterFeatureAttribute.NAME.attrName(), (Object)name);
        newFeature.setAttribute(ClusterFeatureAttribute.GROUP_ID.attrName(), (Object)groupID);
        newFeature.setAttribute(ClusterFeatureAttribute.ITERATION.attrName(), (Object)iteration);
        newFeature.setAttribute(ClusterFeatureAttribute.WEIGHT.attrName(), (Object)weight);
        newFeature.setAttribute(ClusterFeatureAttribute.BATCH_ID.attrName(), (Object)batchId);
        newFeature.setAttribute(ClusterFeatureAttribute.COUNT.attrName(), (Object)count);
        newFeature.setAttribute(ClusterFeatureAttribute.GEOMETRY.attrName(), (Object)geometry);
        newFeature.setAttribute(ClusterFeatureAttribute.ZOOM_LEVEL.attrName(), (Object)zoomLevel);
        int i = 0;
        for (String dimName : extraDimensionNames) {
            newFeature.setAttribute(dimName, (Object)new Double(extraDimensions[i++]));
        }
        return newFeature;
    }

    public static FeatureDataAdapter createFeatureAdapter(String centroidDataTypeId, String[] extraNumericDimensions, String namespaceURI, String SRID, ClusterFeatureAttribute[] attributes, Class<? extends Geometry> geometryClass) {
        try {
            SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
            builder.setName(centroidDataTypeId);
            builder.setNamespaceURI(namespaceURI == null ? "http://www.opengis.net/gml" : namespaceURI);
            builder.setSRS(SRID);
            builder.setCRS(CRS.decode((String)SRID, (boolean)true));
            for (ClusterFeatureAttribute clusterFeatureAttribute : attributes) {
                builder.add(clusterFeatureAttribute.name, clusterFeatureAttribute.equals((Object)ClusterFeatureAttribute.GEOMETRY) ? geometryClass : clusterFeatureAttribute.type);
            }
            for (String string : extraNumericDimensions) {
                builder.add(string, Double.class);
            }
            FeatureDataAdapter featureDataAdapter = new FeatureDataAdapter(builder.buildFeatureType());
            return featureDataAdapter;
        }
        catch (Exception e) {
            LOGGER.warn("Schema Creation Error.  Hint: Check the SRID.", (Throwable)e);
            return null;
        }
    }

    public static FeatureDataAdapter createGeometryFeatureAdapter(String centroidDataTypeId, String[] extraNumericDimensions, String namespaceURI, String SRID) {
        return AnalyticFeature.createFeatureAdapter(centroidDataTypeId, extraNumericDimensions, namespaceURI, SRID, ClusterFeatureAttribute.values(), Geometry.class);
    }

    public static enum ClusterFeatureAttribute {
        NAME("name", String.class),
        GROUP_ID("groupID", String.class),
        ITERATION("iteration", Integer.class),
        GEOMETRY("geometry", Geometry.class),
        WEIGHT("weight", Double.class),
        COUNT("count", Long.class),
        ZOOM_LEVEL("level", Integer.class),
        BATCH_ID("batchID", String.class);

        private final String name;
        private final Class<?> type;

        private ClusterFeatureAttribute(String name, Class<?> type) {
            this.name = name;
            this.type = type;
        }

        public String attrName() {
            return this.name;
        }

        public Class<?> getType() {
            return this.type;
        }
    }
}

