/**
 * Copyright (c) 2013-2022 Contributors to the Eclipse Foundation
 *
 * <p> See the NOTICE file distributed with this work for additional information regarding copyright
 * ownership. All rights reserved. This program and the accompanying materials are made available
 * under the terms of the Apache License, Version 2.0 which accompanies this distribution and is
 * available at http://www.apache.org/licenses/LICENSE-2.0.txt
 */
package org.locationtech.geowave.analytic.param;

import org.locationtech.geowave.analytic.AnalyticItemWrapperFactory;
import org.locationtech.geowave.analytic.extract.CentroidExtractor;

public class CentroidParameters {
  public enum Centroid implements ParameterEnum {
    INDEX_NAME(String.class, "cid", "Index Identifier for Centroids", false, true),
    DATA_TYPE_ID(String.class, "cdt", "Data Type ID for a centroid item", false, true),
    DATA_NAMESPACE_URI(String.class, "cns", "Data Type Namespace for centroid item", false, true),
    CONXVERGANCE_TOLERANCE(Double.class, "cct",
        "The alpha parameter measure the minimum covergence to reach before ", false, true),
    EXTRACTOR_CLASS(CentroidExtractor.class, "cce",
        "Centroid Exractor Class implements org.locationtech.geowave.analytics.extract.CentroidExtractor",
        true, true),
    WRAPPER_FACTORY_CLASS(AnalyticItemWrapperFactory.class, "cfc",
        "A factory class that implements org.locationtech.geowave.analytics.tools.AnalyticItemWrapperFactory",
        true, true),
    ZOOM_LEVEL(Integer.class, "czl", "Zoom Level Number", true, true);
    private final ParameterHelper helper;

    private Centroid(
        final Class baseClass,
        final String name,
        final String description,
        final boolean isClass,
        final boolean hasArg) {
      helper = new BasicParameterHelper(this, baseClass, name, description, isClass, hasArg);
    }

    @Override
    public Enum<?> self() {
      return this;
    }

    @Override
    public ParameterHelper getHelper() {
      return helper;
    }
  }
}
