/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.sample.function;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;
import org.locationtech.geowave.analytic.AnalyticItemWrapper;
import org.locationtech.geowave.analytic.AnalyticItemWrapperFactory;
import org.locationtech.geowave.analytic.PropertyManagement;
import org.locationtech.geowave.analytic.ScopedJobConfiguration;
import org.locationtech.geowave.analytic.SimpleFeatureItemWrapperFactory;
import org.locationtech.geowave.analytic.clustering.CentroidPairing;
import org.locationtech.geowave.analytic.clustering.NestedGroupCentroidAssignment;
import org.locationtech.geowave.analytic.kmeans.AssociationNotification;
import org.locationtech.geowave.analytic.param.CentroidParameters;
import org.locationtech.geowave.analytic.param.ParameterEnum;
import org.locationtech.geowave.analytic.param.SampleParameters;
import org.locationtech.geowave.analytic.sample.RandomProbabilitySampleFn;
import org.locationtech.geowave.analytic.sample.SampleProbabilityFn;
import org.locationtech.geowave.analytic.sample.function.SamplingRankFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CentroidDistanceBasedSamplingRankFunction<T>
implements SamplingRankFunction<T> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(CentroidDistanceBasedSamplingRankFunction.class);
    private SampleProbabilityFn sampleProbabilityFn;
    private NestedGroupCentroidAssignment<T> nestedGroupCentroidAssigner;
    private final Map<String, Double> groupToConstant = new HashMap<String, Double>();
    protected AnalyticItemWrapperFactory<T> itemWrapperFactory;

    public static void setParameters(Configuration config, Class<?> scope, PropertyManagement runTimeProperties) {
        NestedGroupCentroidAssignment.setParameters(config, scope, runTimeProperties);
        runTimeProperties.setConfig(new ParameterEnum[]{SampleParameters.Sample.PROBABILITY_FUNCTION, CentroidParameters.Centroid.WRAPPER_FACTORY_CLASS}, config, scope);
    }

    @Override
    public void initialize(JobContext context, Class<?> scope, Logger logger) throws IOException {
        ScopedJobConfiguration config = new ScopedJobConfiguration(context.getConfiguration(), scope);
        try {
            this.sampleProbabilityFn = config.getInstance(SampleParameters.Sample.PROBABILITY_FUNCTION, SampleProbabilityFn.class, RandomProbabilitySampleFn.class);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        try {
            this.itemWrapperFactory = config.getInstance(CentroidParameters.Centroid.WRAPPER_FACTORY_CLASS, AnalyticItemWrapperFactory.class, SimpleFeatureItemWrapperFactory.class);
            this.itemWrapperFactory.initialize(context, scope, logger);
        }
        catch (Exception e1) {
            throw new IOException(e1);
        }
        try {
            this.nestedGroupCentroidAssigner = new NestedGroupCentroidAssignment(context, scope, logger);
        }
        catch (Exception e1) {
            throw new IOException(e1);
        }
    }

    @Override
    public double rank(int sampleSize, T value) {
        double weight;
        AnalyticItemWrapper<T> item = this.itemWrapperFactory.create(value);
        final ArrayList<AnalyticItemWrapper<T>> centroids = new ArrayList<AnalyticItemWrapper<T>>();
        try {
            weight = this.nestedGroupCentroidAssigner.findCentroidForLevel(item, new AssociationNotification<T>(){

                @Override
                public void notify(CentroidPairing<T> pairing) {
                    try {
                        centroids.addAll(CentroidDistanceBasedSamplingRankFunction.this.nestedGroupCentroidAssigner.getCentroidsForGroup(pairing.getCentroid().getGroupID()));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.sampleProbabilityFn.getProbability(weight, this.getNormalizingConstant(((AnalyticItemWrapper)centroids.get(0)).getGroupID(), centroids), sampleSize);
    }

    private double getNormalizingConstant(String groupID, List<AnalyticItemWrapper<T>> centroids) {
        if (!this.groupToConstant.containsKey(groupID)) {
            double constant = 0.0;
            for (AnalyticItemWrapper<T> centroid : centroids) {
                constant += centroid.getCost();
            }
            this.groupToConstant.put(groupID, constant);
        }
        return this.groupToConstant.get(groupID);
    }
}

