/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.sample;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.TreeMap;
import org.locationtech.geowave.analytic.clustering.CentroidPairing;
import org.locationtech.geowave.analytic.sample.SampleNotification;
import org.locationtech.geowave.analytic.sample.SampleProbabilityFn;

public class Sampler<T> {
    private int sampleSize = 1;
    private int putLimit = 100000;
    private SampleProbabilityFn sampleProbabilityFn;

    public SampleProbabilityFn getSampleProbabilityFn() {
        return this.sampleProbabilityFn;
    }

    public void setSampleProbabilityFn(SampleProbabilityFn sampleProbabilityFn) {
        this.sampleProbabilityFn = sampleProbabilityFn;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public void setSampleSize(int sampleSize) {
        this.sampleSize = sampleSize;
    }

    public int getPutLimit() {
        return this.putLimit;
    }

    public void setPutLimit(int putLimit) {
        this.putLimit = putLimit;
    }

    public void sample(Iterable<CentroidPairing<T>> pairings, SampleNotification<T> notification, double normalizingConstant) {
        int putCounter = 0;
        TreeMap reservoir = Maps.newTreeMap();
        for (CentroidPairing<T> pairing : pairings) {
            double weight = pairing.getDistance();
            if (!(weight > 0.0)) continue;
            double score = this.sampleProbabilityFn.getProbability(weight, normalizingConstant, this.sampleSize);
            if (reservoir.size() < this.sampleSize) {
                reservoir.put(score, pairing.getPairedItem().getWrappedItem());
                ++putCounter;
            } else if (score > (Double)reservoir.firstKey()) {
                reservoir.remove(reservoir.firstKey());
                reservoir.put(score, pairing.getPairedItem().getWrappedItem());
            }
            if (putCounter <= this.putLimit) continue;
            this.notifyAll(notification, reservoir.values(), true);
            reservoir.clear();
            putCounter = 0;
        }
        this.notifyAll(notification, reservoir.values(), false);
    }

    private void notifyAll(SampleNotification<T> notification, Collection<T> items, boolean partial) {
        for (T item : items) {
            notification.notify(item, partial);
        }
    }
}

