/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.partitioner;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;
import org.geotools.referencing.CRS;
import org.locationtech.geowave.analytic.GeometryCalculations;
import org.locationtech.geowave.analytic.PropertyManagement;
import org.locationtech.geowave.analytic.ScopedJobConfiguration;
import org.locationtech.geowave.analytic.extract.DimensionExtractor;
import org.locationtech.geowave.analytic.extract.SimpleFeatureGeometryExtractor;
import org.locationtech.geowave.analytic.param.ExtractParameters;
import org.locationtech.geowave.analytic.param.GlobalParameters;
import org.locationtech.geowave.analytic.param.ParameterEnum;
import org.locationtech.geowave.analytic.param.PartitionParameters;
import org.locationtech.geowave.analytic.partitioner.AbstractPartitioner;
import org.locationtech.geowave.analytic.partitioner.Partitioner;
import org.locationtech.geowave.core.geotime.index.dimension.LatitudeDefinition;
import org.locationtech.geowave.core.geotime.index.dimension.LongitudeDefinition;
import org.locationtech.geowave.core.geotime.util.GeometryUtils;
import org.locationtech.geowave.core.index.dimension.NumericDimensionDefinition;
import org.locationtech.geowave.core.index.sfc.data.BasicNumericDataset;
import org.locationtech.geowave.core.index.sfc.data.MultiDimensionalNumericData;
import org.locationtech.geowave.core.index.sfc.data.NumericData;
import org.locationtech.geowave.core.index.sfc.data.NumericRange;
import org.locationtech.geowave.core.store.dimension.NumericDimensionField;
import org.locationtech.geowave.core.store.index.CommonIndexModel;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.uom.SI;
import tec.uom.se.unit.Units;

public class OrthodromicDistancePartitioner<T>
extends AbstractPartitioner<T>
implements Partitioner<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    static final Logger LOGGER = LoggerFactory.getLogger(OrthodromicDistancePartitioner.class);
    private Unit<Length> geometricDistanceUnit = SI.METRE;
    private String crsName;
    private transient CoordinateReferenceSystem crs = null;
    private transient GeometryCalculations calculator;
    protected DimensionExtractor<T> dimensionExtractor;
    private int latDimensionPosition;
    private int longDimensionPosition;

    public OrthodromicDistancePartitioner() {
    }

    public OrthodromicDistancePartitioner(CoordinateReferenceSystem crs, CommonIndexModel indexModel, DimensionExtractor<T> dimensionExtractor, double[] distancePerDimension, Unit<Length> geometricDistanceUnit) {
        super(distancePerDimension);
        this.crs = crs;
        this.crsName = ((ReferenceIdentifier)crs.getIdentifiers().iterator().next()).toString();
        this.geometricDistanceUnit = geometricDistanceUnit;
        this.dimensionExtractor = dimensionExtractor;
        this.initIndex(indexModel, distancePerDimension);
    }

    @Override
    protected AbstractPartitioner.NumericDataHolder getNumericData(T entry) {
        AbstractPartitioner.NumericDataHolder numericDataHolder = new AbstractPartitioner.NumericDataHolder();
        Geometry entryGeometry = this.dimensionExtractor.getGeometry(entry);
        double[] otherDimensionData = this.dimensionExtractor.getDimensions(entry);
        numericDataHolder.primary = this.getNumericData(entryGeometry.getEnvelope(), otherDimensionData);
        List<Geometry> geometries = this.getGeometries(entryGeometry.getCentroid().getCoordinate(), this.getDistancePerDimension());
        MultiDimensionalNumericData[] values = new MultiDimensionalNumericData[geometries.size()];
        int i = 0;
        for (Geometry geometry : geometries) {
            values[i++] = this.getNumericData(geometry.getEnvelope(), otherDimensionData);
        }
        numericDataHolder.expansion = values;
        return numericDataHolder;
    }

    private MultiDimensionalNumericData getNumericData(Geometry geometry, double[] otherDimensionData) {
        NumericDimensionField[] dimensionFields = this.getIndex().getIndexModel().getDimensions();
        NumericData[] numericData = new NumericData[dimensionFields.length];
        double[] distancePerDimension = this.getDistancePerDimension();
        int otherIndex = 0;
        for (int i = 0; i < dimensionFields.length; ++i) {
            double maxValue;
            double minValue;
            double d = i == this.longDimensionPosition ? geometry.getEnvelopeInternal().getMinX() : (minValue = i == this.latDimensionPosition ? geometry.getEnvelopeInternal().getMinY() : otherDimensionData[otherIndex] - distancePerDimension[i]);
            double d2 = i == this.longDimensionPosition ? geometry.getEnvelopeInternal().getMaxX() : (maxValue = i == this.latDimensionPosition ? geometry.getEnvelopeInternal().getMaxY() : otherDimensionData[otherIndex] + distancePerDimension[i]);
            if (i != this.longDimensionPosition && i != this.latDimensionPosition) {
                ++otherIndex;
            }
            numericData[i] = new NumericRange(minValue, maxValue);
        }
        return new BasicNumericDataset(numericData);
    }

    private static int findLongitude(CommonIndexModel indexModel) {
        return OrthodromicDistancePartitioner.indexOf(indexModel.getDimensions(), LongitudeDefinition.class);
    }

    private static int findLatitude(CommonIndexModel indexModel) {
        return OrthodromicDistancePartitioner.indexOf(indexModel.getDimensions(), LatitudeDefinition.class);
    }

    private static int indexOf(NumericDimensionField<?>[] fields, Class<? extends NumericDimensionDefinition> clazz) {
        for (int i = 0; i < fields.length; ++i) {
            if (!clazz.isInstance(fields[i].getBaseDefinition())) continue;
            return i;
        }
        return -1;
    }

    private List<Geometry> getGeometries(Coordinate coordinate, double[] distancePerDimension) {
        return this.getCalculator().buildSurroundingGeometries(new double[]{distancePerDimension[this.longDimensionPosition], distancePerDimension[this.latDimensionPosition]}, this.geometricDistanceUnit == null ? Units.METRE : this.geometricDistanceUnit, coordinate);
    }

    private GeometryCalculations getCalculator() {
        if (this.calculator == null) {
            if (this.crs == null) {
                try {
                    this.crs = CRS.decode((String)this.crsName, (boolean)true);
                }
                catch (FactoryException e) {
                    LOGGER.error("CRS not providd and default EPSG:4326 cannot be instantiated", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            this.calculator = new GeometryCalculations(this.crs);
        }
        return this.calculator;
    }

    @Override
    protected void initIndex(CommonIndexModel indexModel, double[] distancePerDimension) {
        this.longDimensionPosition = OrthodromicDistancePartitioner.findLongitude(indexModel);
        this.latDimensionPosition = OrthodromicDistancePartitioner.findLatitude(indexModel);
        List<Geometry> geos = this.getGeometries(new Coordinate(0.0, 0.0), distancePerDimension);
        Envelope envelope = geos.get(0).getEnvelopeInternal();
        double[] distancePerDimensionForIndex = new double[distancePerDimension.length];
        for (int i = 0; i < distancePerDimension.length; ++i) {
            distancePerDimensionForIndex[i] = i == this.longDimensionPosition ? envelope.getWidth() / 2.0 : (i == this.latDimensionPosition ? envelope.getHeight() / 2.0 : distancePerDimension[i]);
            LOGGER.info("Dimension size {} is {} ", (Object)i, (Object)distancePerDimensionForIndex[i]);
        }
        super.initIndex(indexModel, distancePerDimensionForIndex);
    }

    @Override
    public void initialize(JobContext context, Class<?> scope) throws IOException {
        this.initialize(context.getConfiguration(), scope);
    }

    public void initialize(Configuration configuration, Class<?> scope) throws IOException {
        this.initialize(new ScopedJobConfiguration(configuration, scope));
    }

    @Override
    public void initialize(ScopedJobConfiguration config) throws IOException {
        this.crsName = config.getString(GlobalParameters.Global.CRS_ID, "EPSG:4326");
        try {
            this.crs = CRS.decode((String)this.crsName, (boolean)true);
        }
        catch (FactoryException e) {
            throw new IOException("Cannot find CRS " + this.crsName, e);
        }
        try {
            this.dimensionExtractor = config.getInstance(ExtractParameters.Extract.DIMENSION_EXTRACT_CLASS, DimensionExtractor.class, SimpleFeatureGeometryExtractor.class);
        }
        catch (Exception ex) {
            throw new IOException("Cannot find class for  " + ExtractParameters.Extract.DIMENSION_EXTRACT_CLASS.toString(), ex);
        }
        String distanceUnit = config.getString(PartitionParameters.Partition.GEOMETRIC_DISTANCE_UNIT, "m");
        this.geometricDistanceUnit = GeometryUtils.lookup((String)distanceUnit);
        super.initialize(config);
    }

    @Override
    public Collection<ParameterEnum<?>> getParameters() {
        HashSet params = new HashSet();
        params.addAll(super.getParameters());
        params.addAll(Arrays.asList(PartitionParameters.Partition.GEOMETRIC_DISTANCE_UNIT, ExtractParameters.Extract.DIMENSION_EXTRACT_CLASS));
        return params;
    }

    @Override
    public void setup(PropertyManagement runTimeProperties, Class<?> scope, Configuration configuration) {
        super.setup(runTimeProperties, scope, configuration);
        ParameterEnum[] params = new ParameterEnum[]{GlobalParameters.Global.CRS_ID, ExtractParameters.Extract.DIMENSION_EXTRACT_CLASS, PartitionParameters.Partition.GEOMETRIC_DISTANCE_UNIT};
        runTimeProperties.setConfig(params, configuration, scope);
    }
}

