/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.partitioner;

import com.google.common.collect.Iterators;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;
import org.locationtech.geowave.analytic.PropertyManagement;
import org.locationtech.geowave.analytic.SerializableAdapterStore;
import org.locationtech.geowave.analytic.param.ParameterEnum;
import org.locationtech.geowave.analytic.param.StoreParameters;
import org.locationtech.geowave.analytic.partitioner.AbstractPartitioner;
import org.locationtech.geowave.analytic.partitioner.Partitioner;
import org.locationtech.geowave.analytic.store.PersistableStore;
import org.locationtech.geowave.core.geotime.index.dimension.LongitudeDefinition;
import org.locationtech.geowave.core.index.dimension.NumericDimensionDefinition;
import org.locationtech.geowave.core.index.sfc.data.BasicNumericDataset;
import org.locationtech.geowave.core.index.sfc.data.MultiDimensionalNumericData;
import org.locationtech.geowave.core.index.sfc.data.NumericData;
import org.locationtech.geowave.core.index.sfc.data.NumericRange;
import org.locationtech.geowave.core.store.CloseableIterator;
import org.locationtech.geowave.core.store.CloseableIteratorWrapper;
import org.locationtech.geowave.core.store.adapter.AdapterPersistenceEncoding;
import org.locationtech.geowave.core.store.adapter.InternalAdapterStore;
import org.locationtech.geowave.core.store.adapter.InternalDataAdapterWrapper;
import org.locationtech.geowave.core.store.adapter.PersistentAdapterStore;
import org.locationtech.geowave.core.store.adapter.TransientAdapterStore;
import org.locationtech.geowave.core.store.api.DataTypeAdapter;
import org.locationtech.geowave.core.store.cli.store.DataStorePluginOptions;
import org.locationtech.geowave.core.store.index.CommonIndexModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdapterBasedPartitioner
extends AbstractPartitioner<AdapterDataEntry>
implements Partitioner<AdapterDataEntry>,
Serializable {
    static final Logger LOGGER = LoggerFactory.getLogger(AdapterBasedPartitioner.class);
    private static final long serialVersionUID = 5951564193108204266L;
    private NumericData[] fullRangesPerDimension;
    private boolean[] wrapsAroundBoundary;
    private SerializableAdapterStore adapterStore;

    public AdapterBasedPartitioner() {
    }

    public AdapterBasedPartitioner(CommonIndexModel indexModel, double[] distancesPerDimension, TransientAdapterStore adapterStore) {
        super(indexModel, distancesPerDimension);
        this.adapterStore = new SerializableAdapterStore(adapterStore);
        this.init();
    }

    @Override
    protected AbstractPartitioner.NumericDataHolder getNumericData(AdapterDataEntry entry) {
        MultiDimensionalNumericData primaryData;
        AbstractPartitioner.NumericDataHolder numericDataHolder = new AbstractPartitioner.NumericDataHolder();
        DataTypeAdapter<?> adapter = this.adapterStore.getAdapter(entry.adapterId);
        if (adapter == null) {
            LOGGER.error("Unable to find an adapter for id {}", (Object)entry.adapterId.toString());
            return null;
        }
        AdapterPersistenceEncoding encoding = adapter.encode(entry.data, this.getIndex().getIndexModel());
        double[] thetas = this.getDistancePerDimension();
        numericDataHolder.primary = primaryData = encoding.getNumericData(this.getIndex().getIndexModel().getDimensions());
        numericDataHolder.expansion = this.querySet(primaryData, thetas);
        return numericDataHolder;
    }

    protected void init() {
        NumericDimensionDefinition[] definitions = this.getIndex().getIndexStrategy().getOrderedDimensionDefinitions();
        this.fullRangesPerDimension = new NumericData[definitions.length];
        this.wrapsAroundBoundary = new boolean[definitions.length];
        for (int i = 0; i < definitions.length; ++i) {
            this.fullRangesPerDimension[i] = definitions[i].getFullRange();
            this.wrapsAroundBoundary[i] = this.getIndex().getIndexModel().getDimensions()[i].getBaseDefinition() instanceof LongitudeDefinition;
        }
    }

    @Override
    public void initialize(JobContext context, Class<?> scope) throws IOException {
        super.initialize(context, scope);
        this.adapterStore = new SerializableAdapterStore(new PersistentAdapterStoreAsTransient(((PersistableStore)StoreParameters.StoreParam.INPUT_STORE.getHelper().getValue(context, scope, null)).getDataStoreOptions()));
        this.init();
    }

    @Override
    public void setup(PropertyManagement runTimeProperties, Class<?> scope, Configuration configuration) {
        super.setup(runTimeProperties, scope, configuration);
        ParameterEnum[] params = new ParameterEnum[]{StoreParameters.StoreParam.INPUT_STORE};
        runTimeProperties.setConfig(params, configuration, scope);
    }

    protected MultiDimensionalNumericData[] querySet(MultiDimensionalNumericData dimensionsData, double[] distances) {
        ArrayList<NumericRange[]> resultList = new ArrayList<NumericRange[]>();
        NumericRange[] currentData = new NumericRange[dimensionsData.getDimensionCount()];
        this.addToList(resultList, currentData, distances, dimensionsData, 0);
        MultiDimensionalNumericData[] finalSet = new MultiDimensionalNumericData[resultList.size()];
        int i = 0;
        for (NumericRange[] rangeData : resultList) {
            finalSet[i++] = new BasicNumericDataset((NumericData[])rangeData);
        }
        return finalSet;
    }

    private void addToList(List<NumericRange[]> resultList, NumericRange[] currentData, double[] distances, MultiDimensionalNumericData dimensionsData, int d) {
        if (d == currentData.length) {
            resultList.add(Arrays.copyOf(currentData, currentData.length));
            return;
        }
        NumericData dimensionData = dimensionsData.getDataPerDimension()[d];
        double lowerBound = dimensionData.getMin() - distances[d];
        double upperBound = dimensionData.getMax() + distances[d];
        double mindiff = lowerBound - this.fullRangesPerDimension[d].getMin();
        double maxdiff = upperBound - this.fullRangesPerDimension[d].getMax();
        if (this.wrapsAroundBoundary[d] && mindiff < 0.0) {
            currentData[d] = new NumericRange(this.fullRangesPerDimension[d].getMax() + mindiff, this.fullRangesPerDimension[d].getMax());
            this.addToList(resultList, currentData, distances, dimensionsData, d + 1);
            currentData[d] = new NumericRange(this.fullRangesPerDimension[d].getMin(), upperBound);
            this.addToList(resultList, currentData, distances, dimensionsData, d + 1);
        } else if (this.wrapsAroundBoundary[d] && maxdiff > 0.0) {
            currentData[d] = new NumericRange(lowerBound, this.fullRangesPerDimension[d].getMax());
            this.addToList(resultList, currentData, distances, dimensionsData, d + 1);
            currentData[d] = new NumericRange(this.fullRangesPerDimension[d].getMin(), this.fullRangesPerDimension[d].getMin() + maxdiff);
            this.addToList(resultList, currentData, distances, dimensionsData, d + 1);
        } else {
            currentData[d] = new NumericRange(lowerBound, upperBound);
            this.addToList(resultList, currentData, distances, dimensionsData, d + 1);
        }
    }

    private static class PersistentAdapterStoreAsTransient
    implements TransientAdapterStore {
        private final PersistentAdapterStore adapterStore;
        private final InternalAdapterStore internalAdapterStore;

        private PersistentAdapterStoreAsTransient(DataStorePluginOptions dataStoreOptions) {
            this(dataStoreOptions.createAdapterStore(), dataStoreOptions.createInternalAdapterStore());
        }

        private PersistentAdapterStoreAsTransient(PersistentAdapterStore adapterStore, InternalAdapterStore internalAdapterStore) {
            this.adapterStore = adapterStore;
            this.internalAdapterStore = internalAdapterStore;
        }

        public void addAdapter(DataTypeAdapter<?> adapter) {
            this.adapterStore.addAdapter((DataTypeAdapter)new InternalDataAdapterWrapper(adapter, this.internalAdapterStore.addTypeName(adapter.getTypeName())));
        }

        public DataTypeAdapter<?> getAdapter(String typeName) {
            return this.adapterStore.getAdapter((Object)this.internalAdapterStore.getAdapterId(typeName));
        }

        public boolean adapterExists(String typeName) {
            return this.adapterStore.adapterExists((Object)this.internalAdapterStore.getAdapterId(typeName));
        }

        public CloseableIterator<DataTypeAdapter<?>> getAdapters() {
            CloseableIterator it = this.adapterStore.getAdapters();
            return new CloseableIteratorWrapper((Closeable)it, Iterators.transform((Iterator)it, input -> input.getAdapter()));
        }

        public void removeAll() {
            this.internalAdapterStore.removeAll();
            this.adapterStore.removeAll();
        }

        public void removeAdapter(String typeName) {
            this.adapterStore.removeAdapter((Object)this.internalAdapterStore.getAdapterId(typeName));
            this.internalAdapterStore.remove(typeName);
        }
    }

    public static class AdapterDataEntry {
        String adapterId;
        Object data;

        public AdapterDataEntry(String adapterId, Object data) {
            this.adapterId = adapterId;
            this.data = data;
        }
    }
}

