/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.partitioner;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;
import org.locationtech.geowave.analytic.PropertyManagement;
import org.locationtech.geowave.analytic.ScopedJobConfiguration;
import org.locationtech.geowave.analytic.model.IndexModelBuilder;
import org.locationtech.geowave.analytic.model.SpatialIndexModelBuilder;
import org.locationtech.geowave.analytic.param.CommonParameters;
import org.locationtech.geowave.analytic.param.ParameterEnum;
import org.locationtech.geowave.analytic.param.PartitionParameters;
import org.locationtech.geowave.analytic.partitioner.Partitioner;
import org.locationtech.geowave.core.index.ByteArray;
import org.locationtech.geowave.core.index.InsertionIds;
import org.locationtech.geowave.core.index.NumericIndexStrategy;
import org.locationtech.geowave.core.index.SinglePartitionInsertionIds;
import org.locationtech.geowave.core.index.dimension.NumericDimensionDefinition;
import org.locationtech.geowave.core.index.persist.Persistable;
import org.locationtech.geowave.core.index.persist.PersistenceUtils;
import org.locationtech.geowave.core.index.sfc.SFCFactory;
import org.locationtech.geowave.core.index.sfc.data.MultiDimensionalNumericData;
import org.locationtech.geowave.core.index.sfc.tiered.TieredSFCIndexFactory;
import org.locationtech.geowave.core.index.sfc.tiered.TieredSFCIndexStrategy;
import org.locationtech.geowave.core.store.api.Index;
import org.locationtech.geowave.core.store.dimension.NumericDimensionField;
import org.locationtech.geowave.core.store.index.CommonIndexModel;
import org.locationtech.geowave.core.store.index.IndexImpl;

public abstract class AbstractPartitioner<T>
implements Partitioner<T> {
    private static final long serialVersionUID = 1L;
    private transient Index index = null;
    private double[] distancePerDimension = null;
    private double precisionFactor = 1.0;

    public AbstractPartitioner() {
    }

    public AbstractPartitioner(CommonIndexModel indexModel, double[] distancePerDimension) {
        this.distancePerDimension = distancePerDimension;
        this.initIndex(indexModel, distancePerDimension);
    }

    public AbstractPartitioner(double[] distancePerDimension) {
        this.distancePerDimension = distancePerDimension;
    }

    protected double[] getDistancePerDimension() {
        return this.distancePerDimension;
    }

    protected Index getIndex() {
        return this.index;
    }

    @Override
    public List<Partitioner.PartitionData> getCubeIdentifiers(T entry) {
        HashSet<Partitioner.PartitionData> partitionIdSet = new HashSet<Partitioner.PartitionData>();
        NumericDataHolder numericData = this.getNumericData(entry);
        if (numericData == null) {
            return Collections.emptyList();
        }
        this.addPartitions(partitionIdSet, this.getIndex().getIndexStrategy().getInsertionIds((Object)numericData.primary), true);
        for (MultiDimensionalNumericData expansionData : numericData.expansion) {
            this.addPartitions(partitionIdSet, this.getIndex().getIndexStrategy().getInsertionIds((Object)expansionData), false);
        }
        return new ArrayList<Partitioner.PartitionData>(partitionIdSet);
    }

    @Override
    public void partition(T entry, Partitioner.PartitionDataCallback callback) throws Exception {
        NumericDataHolder numericData = this.getNumericData(entry);
        if (numericData == null) {
            return;
        }
        InsertionIds primaryIds = this.getIndex().getIndexStrategy().getInsertionIds((Object)numericData.primary);
        for (SinglePartitionInsertionIds partitionInsertionIds : primaryIds.getPartitionKeys()) {
            for (byte[] sortKey : partitionInsertionIds.getSortKeys()) {
                callback.partitionWith(new Partitioner.PartitionData(new ByteArray(partitionInsertionIds.getPartitionKey()), new ByteArray(sortKey), true));
            }
        }
        for (MultiDimensionalNumericData expansionData : numericData.expansion) {
            InsertionIds expansionIds = this.getIndex().getIndexStrategy().getInsertionIds((Object)expansionData);
            for (SinglePartitionInsertionIds partitionInsertionIds : expansionIds.getPartitionKeys()) {
                for (byte[] sortKey : partitionInsertionIds.getSortKeys()) {
                    callback.partitionWith(new Partitioner.PartitionData(new ByteArray(partitionInsertionIds.getPartitionKey()), new ByteArray(sortKey), false));
                }
            }
        }
    }

    protected abstract NumericDataHolder getNumericData(T var1);

    public MultiDimensionalNumericData getRangesForPartition(Partitioner.PartitionData partitionData) {
        return (MultiDimensionalNumericData)this.index.getIndexStrategy().getRangeForId(partitionData.getPartitionKey().getBytes(), partitionData.getSortKey().getBytes());
    }

    protected void addPartitions(Set<Partitioner.PartitionData> masterList, InsertionIds insertionIds, boolean isPrimary) {
        for (SinglePartitionInsertionIds partitionInsertionIds : insertionIds.getPartitionKeys()) {
            for (byte[] sortKey : partitionInsertionIds.getSortKeys()) {
                masterList.add(new Partitioner.PartitionData(new ByteArray(partitionInsertionIds.getPartitionKey()), new ByteArray(sortKey), isPrimary));
            }
        }
    }

    private static double[] getDistances(ScopedJobConfiguration config) {
        String distances = config.getString(PartitionParameters.Partition.DISTANCE_THRESHOLDS, "0.000001");
        String[] distancesArray = distances.split(",");
        double[] distancePerDimension = new double[distancesArray.length];
        int i = 0;
        for (String eachDistance : distancesArray) {
            distancePerDimension[i++] = Double.valueOf(eachDistance);
        }
        return distancePerDimension;
    }

    @Override
    public void initialize(JobContext context, Class<?> scope) throws IOException {
        this.initialize(new ScopedJobConfiguration(context.getConfiguration(), scope));
    }

    public void initialize(ScopedJobConfiguration config) throws IOException {
        this.distancePerDimension = AbstractPartitioner.getDistances(config);
        this.precisionFactor = config.getDouble(PartitionParameters.Partition.PARTITION_PRECISION, 1.0);
        if (this.precisionFactor < 0.0 || this.precisionFactor > 1.0) {
            throw new IllegalArgumentException(String.format("Precision value must be between 0 and 1: %.6f", this.precisionFactor));
        }
        try {
            IndexModelBuilder builder = config.getInstance(CommonParameters.Common.INDEX_MODEL_BUILDER_CLASS, IndexModelBuilder.class, SpatialIndexModelBuilder.class);
            CommonIndexModel model = builder.buildModel();
            if (model.getDimensions().length > this.distancePerDimension.length) {
                double[] newDistancePerDimension = new double[model.getDimensions().length];
                for (int j = 0; j < newDistancePerDimension.length; ++j) {
                    newDistancePerDimension[j] = this.distancePerDimension[j < this.distancePerDimension.length ? j : this.distancePerDimension.length - 1];
                }
                this.distancePerDimension = newDistancePerDimension;
            }
            this.initIndex(model, this.distancePerDimension);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void setup(PropertyManagement runTimeProperties, Class<?> scope, Configuration configuration) {
        ParameterEnum[] params = new ParameterEnum[]{CommonParameters.Common.INDEX_MODEL_BUILDER_CLASS, PartitionParameters.Partition.DISTANCE_THRESHOLDS, PartitionParameters.Partition.PARTITION_PRECISION};
        runTimeProperties.setConfig(params, configuration, scope);
    }

    protected void initIndex(CommonIndexModel indexModel, double[] distancePerDimensionForIndex) {
        NumericDimensionField[] dimensions = indexModel.getDimensions();
        int totalRequestedPrecision = 0;
        int[] dimensionPrecision = new int[indexModel.getDimensions().length];
        for (int i = 0; i < dimensionPrecision.length; ++i) {
            double distance = distancePerDimensionForIndex[i] * 2.0;
            dimensionPrecision[i] = (int)(this.precisionFactor * (double)Math.abs((int)(Math.log(dimensions[i].getRange() / distance) / Math.log(2.0))));
            totalRequestedPrecision += dimensionPrecision[i];
        }
        if (totalRequestedPrecision > 63) {
            double rescale = 63.0 / (double)totalRequestedPrecision;
            for (int i = 0; i < dimensionPrecision.length; ++i) {
                dimensionPrecision[i] = (int)(rescale * (double)dimensionPrecision[i]);
            }
        }
        TieredSFCIndexStrategy indexStrategy = TieredSFCIndexFactory.createSingleTierStrategy((NumericDimensionDefinition[])indexModel.getDimensions(), (int[])dimensionPrecision, (SFCFactory.SFCType)SFCFactory.SFCType.HILBERT);
        indexStrategy.setMaxEstimatedDuplicateIdsPerDimension(2);
        this.index = new IndexImpl((NumericIndexStrategy)indexStrategy, indexModel);
    }

    @Override
    public Collection<ParameterEnum<?>> getParameters() {
        return Arrays.asList(CommonParameters.Common.INDEX_MODEL_BUILDER_CLASS, PartitionParameters.Partition.DISTANCE_THRESHOLDS, PartitionParameters.Partition.PARTITION_PRECISION);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        byte[] indexData = PersistenceUtils.toBinary((Persistable)this.index);
        stream.writeInt(indexData.length);
        stream.write(indexData);
        stream.writeDouble(this.precisionFactor);
        stream.writeInt(this.distancePerDimension.length);
        for (double v : this.distancePerDimension) {
            stream.writeDouble(v);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        byte[] indexData = new byte[stream.readInt()];
        stream.readFully(indexData);
        this.index = (Index)PersistenceUtils.fromBinary((byte[])indexData);
        this.precisionFactor = stream.readDouble();
        this.distancePerDimension = new double[stream.readInt()];
        for (int i = 0; i < this.distancePerDimension.length; ++i) {
            this.distancePerDimension[i] = stream.readDouble();
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.distancePerDimension);
        result = 31 * result + (this.index == null ? 0 : this.index.hashCode());
        long temp = Double.doubleToLongBits(this.precisionFactor);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractPartitioner other = (AbstractPartitioner)obj;
        if (!Arrays.equals(this.distancePerDimension, other.distancePerDimension)) {
            return false;
        }
        if (this.index == null ? other.index != null : !this.index.equals(other.index)) {
            return false;
        }
        return Double.doubleToLongBits(this.precisionFactor) == Double.doubleToLongBits(other.precisionFactor);
    }

    protected static class NumericDataHolder {
        MultiDimensionalNumericData primary;
        MultiDimensionalNumericData[] expansion;

        protected NumericDataHolder() {
        }
    }
}

