/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.param;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;
import org.locationtech.geowave.analytic.PropertyManagement;
import org.locationtech.geowave.analytic.ScopedJobConfiguration;
import org.locationtech.geowave.analytic.param.ParameterEnum;
import org.locationtech.geowave.analytic.param.ParameterHelper;
import org.locationtech.geowave.core.index.ByteArrayUtils;
import org.locationtech.geowave.mapreduce.GeoWaveConfiguratorBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicParameterHelper
implements ParameterHelper<Object> {
    private static final long serialVersionUID = 1L;
    static final Logger LOGGER = LoggerFactory.getLogger(BasicParameterHelper.class);
    private final ParameterEnum<?> parent;
    private final Class<Object> baseClass;
    private final boolean isClass;

    public BasicParameterHelper(ParameterEnum<?> parent, Class<Object> baseClass, String name, String description, boolean isClass, boolean hasArg) {
        this.baseClass = baseClass;
        this.parent = parent;
        this.isClass = isClass;
    }

    @Override
    public Class<Object> getBaseClass() {
        return this.baseClass;
    }

    @Override
    public void setValue(Configuration config, Class<?> scope, Object value) {
        BasicParameterHelper.setParameter(config, scope, value, this.parent);
    }

    private static final void setParameter(Configuration config, Class<?> scope, Object val, ParameterEnum configItem) {
        if (val != null) {
            if (val instanceof Long) {
                config.setLong(GeoWaveConfiguratorBase.enumToConfKey(scope, configItem.self()), ((Long)val).longValue());
            } else if (val instanceof Double) {
                config.setDouble(GeoWaveConfiguratorBase.enumToConfKey(scope, configItem.self()), ((Double)val).doubleValue());
            } else if (val instanceof Boolean) {
                config.setBoolean(GeoWaveConfiguratorBase.enumToConfKey(scope, configItem.self()), ((Boolean)val).booleanValue());
            } else if (val instanceof Integer) {
                config.setInt(GeoWaveConfiguratorBase.enumToConfKey(scope, configItem.self()), ((Integer)val).intValue());
            } else if (val instanceof Class) {
                config.setClass(GeoWaveConfiguratorBase.enumToConfKey(scope, configItem.self()), (Class)val, (Class)val);
            } else if (val instanceof byte[]) {
                config.set(GeoWaveConfiguratorBase.enumToConfKey(scope, configItem.self()), ByteArrayUtils.byteArrayToString((byte[])((byte[])val)));
            } else {
                config.set(GeoWaveConfiguratorBase.enumToConfKey(scope, configItem.self()), val.toString());
            }
        }
    }

    @Override
    public Object getValue(JobContext context, Class<?> scope, Object defaultValue) {
        ScopedJobConfiguration scopedConfig = new ScopedJobConfiguration(context.getConfiguration(), scope);
        if (this.baseClass.isAssignableFrom(Integer.class)) {
            return scopedConfig.getInt(this.parent.self(), (Integer)defaultValue);
        }
        if (this.baseClass.isAssignableFrom(String.class)) {
            return scopedConfig.getString(this.parent.self(), defaultValue.toString());
        }
        if (this.baseClass.isAssignableFrom(Double.class)) {
            return scopedConfig.getDouble(this.parent.self(), (Double)defaultValue);
        }
        if (this.baseClass.isAssignableFrom(byte[].class)) {
            return scopedConfig.getBytes(this.parent.self());
        }
        if (defaultValue == null || defaultValue instanceof Class) {
            try {
                return scopedConfig.getInstance(this.parent.self(), this.baseClass, (Class)defaultValue);
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOGGER.error("Unable to get instance from job context", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public Object getValue(PropertyManagement propertyManagement) {
        try {
            return propertyManagement.getProperty(this.parent);
        }
        catch (Exception e) {
            LOGGER.error("Unable to deserialize property '" + this.parent.toString() + "'", (Throwable)e);
            return null;
        }
    }

    @Override
    public void setValue(PropertyManagement propertyManagement, Object value) {
        Class<?> storeValue = value;
        if (this.isClass && value instanceof String) {
            try {
                storeValue = Class.forName(((Object)value).toString());
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("Class " + ((Object)value).toString() + " for property " + this.parent + " is not found", (Throwable)e);
            }
        }
        propertyManagement.store(this.parent, storeValue);
    }
}

