/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.nn;

import java.util.HashMap;
import java.util.Map;
import org.locationtech.geowave.analytic.nn.DistanceProfile;
import org.locationtech.geowave.analytic.nn.NeighborList;
import org.locationtech.geowave.analytic.nn.NeighborListFactory;
import org.locationtech.geowave.analytic.nn.NullList;
import org.locationtech.geowave.core.index.ByteArray;

public class NeighborIndex<NNTYPE> {
    private final Map<ByteArray, NeighborList<NNTYPE>> index = new HashMap<ByteArray, NeighborList<NNTYPE>>();
    private final NeighborListFactory<NNTYPE> listFactory;
    private final NullList<NNTYPE> nullList = new NullList();

    public NeighborIndex(NeighborListFactory<NNTYPE> listFactory) {
        this.listFactory = listFactory;
    }

    public NeighborList<NNTYPE> init(ByteArray id, NNTYPE value) {
        NeighborList<NNTYPE> neighbors = this.index.get(id);
        if (neighbors == null) {
            neighbors = this.listFactory.buildNeighborList(id, value);
            this.index.put(id, neighbors);
        }
        return neighbors;
    }

    public void add(DistanceProfile<?> distanceProfile, ByteArray centerId, NNTYPE centerValue, ByteArray neighborId, NNTYPE neighborValue, boolean addReciprical) {
        this.addToList(distanceProfile, centerId, centerValue, neighborId, neighborValue);
        if (addReciprical) {
            this.addToList(distanceProfile, neighborId, neighborValue, centerId, centerValue);
        }
    }

    public void empty(ByteArray id) {
        this.index.put(id, this.nullList);
    }

    private void addToList(DistanceProfile<?> distanceProfile, ByteArray centerId, NNTYPE centerValue, ByteArray neighborId, NNTYPE neighborValue) {
        NeighborList<NNTYPE> neighbors = this.index.get(centerId);
        if (neighbors == null) {
            neighbors = this.listFactory.buildNeighborList(centerId, centerValue);
            this.index.put(centerId, neighbors);
        }
        neighbors.add(distanceProfile, neighborId, neighborValue);
    }
}

