/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.nn;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.locationtech.geowave.analytic.nn.DistanceProfile;
import org.locationtech.geowave.analytic.nn.DistanceProfileGenerateFn;
import org.locationtech.geowave.analytic.nn.NeighborIndex;
import org.locationtech.geowave.analytic.nn.NeighborList;
import org.locationtech.geowave.analytic.nn.NeighborListFactory;
import org.locationtech.geowave.analytic.nn.TypeConverter;
import org.locationtech.geowave.analytic.partitioner.Partitioner;
import org.locationtech.geowave.core.index.ByteArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NNProcessor<PARTITION_VALUE, STORE_VALUE> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(NNProcessor.class);
    final Map<Partitioner.PartitionData, Partitioner.PartitionData> uniqueSetOfPartitions = new HashMap<Partitioner.PartitionData, Partitioner.PartitionData>();
    final Map<Partitioner.PartitionData, Set<ByteArray>> partitionsToIds = new HashMap<Partitioner.PartitionData, Set<ByteArray>>();
    final Map<ByteArray, Set<Partitioner.PartitionData>> idsToPartition = new HashMap<ByteArray, Set<Partitioner.PartitionData>>();
    final Map<ByteArray, STORE_VALUE> primaries = new HashMap<ByteArray, STORE_VALUE>();
    final Map<ByteArray, STORE_VALUE> others = new HashMap<ByteArray, STORE_VALUE>();
    protected final Partitioner<Object> partitioner;
    protected final TypeConverter<STORE_VALUE> typeConverter;
    protected final DistanceProfileGenerateFn<?, STORE_VALUE> distanceProfileFn;
    protected final double maxDistance;
    protected final Partitioner.PartitionData parentPartition;
    private int upperBoundPerPartition = 75000;
    public static final int DEFAULT_UPPER_BOUND_PARTIION_SIZE = 75000;
    protected ByteArray startingPoint;
    protected NeighborIndex<STORE_VALUE> index;

    public NNProcessor(Partitioner<Object> partitioner, TypeConverter<STORE_VALUE> typeConverter, DistanceProfileGenerateFn<?, STORE_VALUE> distanceProfileFn, double maxDistance, Partitioner.PartitionData parentPartition) {
        this.partitioner = partitioner;
        this.typeConverter = typeConverter;
        this.distanceProfileFn = distanceProfileFn;
        this.maxDistance = maxDistance;
        this.parentPartition = parentPartition;
    }

    private Partitioner.PartitionData add(Partitioner.PartitionData pd, ByteArray itemId) {
        Set<ByteArray> idsSet;
        Partitioner.PartitionData singleton = this.uniqueSetOfPartitions.get(pd);
        if (singleton == null) {
            this.uniqueSetOfPartitions.put(pd, pd);
            singleton = pd;
        }
        if ((idsSet = this.partitionsToIds.get(singleton)) == null) {
            idsSet = new HashSet<ByteArray>();
            this.partitionsToIds.put(singleton, idsSet);
        }
        if (idsSet.size() > this.upperBoundPerPartition) {
            return null;
        }
        if (idsSet.size() == this.upperBoundPerPartition) {
            LOGGER.warn("At upper bound on partition.  Increase the bounds or condense the data.");
        }
        idsSet.add(itemId);
        Set<Partitioner.PartitionData> partitionSet = this.idsToPartition.get(itemId);
        if (partitionSet == null) {
            partitionSet = new HashSet<Partitioner.PartitionData>();
            this.idsToPartition.put(itemId, partitionSet);
        }
        partitionSet.add(singleton);
        return singleton;
    }

    public void remove(ByteArray id) {
        Set<Partitioner.PartitionData> partitionSet = this.idsToPartition.remove(id);
        if (partitionSet != null) {
            for (Partitioner.PartitionData pd : partitionSet) {
                Set<ByteArray> idSet = this.partitionsToIds.get(pd);
                if (idSet == null) continue;
                idSet.remove(id);
            }
        }
        this.primaries.remove(id);
        this.others.remove(id);
        if (this.index != null) {
            this.index.empty(id);
        }
    }

    public void add(final ByteArray id, final boolean isPrimary, PARTITION_VALUE partitionValue) throws IOException {
        final STORE_VALUE storeValue = this.typeConverter.convert(id, partitionValue);
        try {
            this.partitioner.partition(partitionValue, new Partitioner.PartitionDataCallback(){

                @Override
                public void partitionWith(Partitioner.PartitionData partitionData) throws Exception {
                    Partitioner.PartitionData singleton = NNProcessor.this.add(partitionData, id);
                    if (singleton != null) {
                        singleton.setPrimary(partitionData.isPrimary() || singleton.isPrimary());
                        if (isPrimary) {
                            NNProcessor.this.primaries.put(id, storeValue);
                        } else {
                            NNProcessor.this.others.put(id, storeValue);
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        if (isPrimary && this.startingPoint == null) {
            this.startingPoint = id;
        }
    }

    public int size() {
        return this.primaries.size() + this.others.size();
    }

    public boolean trimSmallPartitions(int size) {
        Iterator<Map.Entry<Partitioner.PartitionData, Set<ByteArray>>> it = this.partitionsToIds.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Partitioner.PartitionData, Set<ByteArray>> entry = it.next();
            if (entry.getValue().size() >= size) continue;
            for (ByteArray id : entry.getValue()) {
                Set<Partitioner.PartitionData> partitionsForId = this.idsToPartition.get(id);
                partitionsForId.remove(entry.getKey());
                if (!partitionsForId.isEmpty()) continue;
                this.primaries.remove(id);
                this.others.remove(id);
            }
            it.remove();
        }
        return this.partitionsToIds.isEmpty();
    }

    public void process(NeighborListFactory<STORE_VALUE> listFactory, CompleteNotifier<STORE_VALUE> notification) throws IOException, InterruptedException {
        LOGGER.info("Processing " + this.parentPartition.toString() + " with primary = " + this.primaries.size() + " and other = " + this.others.size());
        LOGGER.info("Processing " + this.parentPartition.toString() + " with sub-partitions = " + this.uniqueSetOfPartitions.size());
        this.index = new NeighborIndex<STORE_VALUE>(listFactory);
        double farthestDistance = 0.0;
        ByteArray farthestNeighbor = null;
        ByteArray nextStart = this.startingPoint;
        HashSet<ByteArray> inspectionSet = new HashSet<ByteArray>();
        inspectionSet.addAll(this.primaries.keySet());
        if (inspectionSet.size() > 0 && nextStart == null) {
            nextStart = (ByteArray)inspectionSet.iterator().next();
        }
        while (nextStart != null) {
            inspectionSet.remove(nextStart);
            farthestDistance = 0.0;
            Set<Partitioner.PartitionData> partition = this.idsToPartition.get(nextStart);
            STORE_VALUE primary = this.primaries.get(nextStart);
            ByteArray primaryId = nextStart;
            nextStart = null;
            farthestNeighbor = null;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("processing " + primaryId);
            }
            if (primary == null) {
                if (inspectionSet.size() <= 0) continue;
                nextStart = (ByteArray)inspectionSet.iterator().next();
                continue;
            }
            NeighborList<STORE_VALUE> primaryList = this.index.init(primaryId, primary);
            for (Partitioner.PartitionData pd : partition) {
                for (ByteArray neighborId : this.partitionsToIds.get(pd)) {
                    if (neighborId.equals((Object)primaryId)) continue;
                    boolean isAPrimary = true;
                    STORE_VALUE neighbor = this.primaries.get(neighborId);
                    if (neighbor == null) {
                        neighbor = this.others.get(neighborId);
                        isAPrimary = false;
                    } else if (!inspectionSet.contains(neighborId)) continue;
                    if (neighbor == null) continue;
                    NeighborList.InferType inferResult = primaryList.infer(neighborId, neighbor);
                    if (inferResult == NeighborList.InferType.NONE) {
                        DistanceProfile<?> distanceProfile = this.distanceProfileFn.computeProfile(primary, neighbor);
                        double distance = distanceProfile.getDistance();
                        if (distance <= this.maxDistance) {
                            this.index.add(distanceProfile, primaryId, primary, neighborId, neighbor, isAPrimary);
                            if (LOGGER.isTraceEnabled()) {
                                LOGGER.trace("Neighbor " + neighborId);
                            }
                        }
                        if (!(distance > farthestDistance) || !inspectionSet.contains(neighborId)) continue;
                        farthestDistance = distance;
                        farthestNeighbor = neighborId;
                        continue;
                    }
                    if (inferResult != NeighborList.InferType.REMOVE) continue;
                    inspectionSet.remove(neighborId);
                }
            }
            notification.complete(primaryId, primary, primaryList);
            this.index.empty(primaryId);
            if (farthestNeighbor == null && inspectionSet.size() > 0) {
                nextStart = (ByteArray)inspectionSet.iterator().next();
                continue;
            }
            nextStart = farthestNeighbor;
        }
    }

    public int getUpperBoundPerPartition() {
        return this.upperBoundPerPartition;
    }

    public void setUpperBoundPerPartition(int upperBoundPerPartition) {
        this.upperBoundPerPartition = upperBoundPerPartition;
    }

    public static interface CompleteNotifier<STORE_VALUE> {
        public void complete(ByteArray var1, STORE_VALUE var2, NeighborList<STORE_VALUE> var3) throws IOException, InterruptedException;
    }
}

