/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import org.locationtech.geowave.core.index.persist.Persistable;
import org.locationtech.geowave.core.index.persist.PersistenceUtils;

public class PersistableSerializer
extends Serializer<Persistable> {
    public Persistable read(Kryo kryo, Input input, Class<Persistable> classTag) {
        int byteCount = input.readInt();
        byte[] bytes = new byte[byteCount];
        int bytesRead = input.read(bytes);
        if (bytesRead < 0) {
            return null;
        }
        return PersistenceUtils.fromBinary((byte[])bytes);
    }

    public void write(Kryo kryo, Output output, Persistable object) {
        byte[] serializedObj = PersistenceUtils.toBinary((Persistable)object);
        int objLength = serializedObj.length;
        output.writeInt(objLength);
        output.write(serializedObj);
    }
}

