/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.locationtech.geowave.adapter.vector.FeatureWritable;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureSerializer
extends Serializer<SimpleFeature> {
    static final Logger LOGGER = LoggerFactory.getLogger(FeatureSerializer.class);

    public SimpleFeature read(Kryo arg0, Input arg1, Class<SimpleFeature> arg2) {
        FeatureWritable fw = new FeatureWritable();
        byte[] data = arg1.readBytes(arg1.readInt());
        try (DataInputStream is = new DataInputStream(new ByteArrayInputStream(data));){
            fw.readFields((DataInput)is);
        }
        catch (IOException e) {
            LOGGER.error("Cannot deserialize Simple Feature", (Throwable)e);
            return null;
        }
        return fw.getFeature();
    }

    public void write(Kryo arg0, Output arg1, SimpleFeature arg2) {
        FeatureWritable fw = new FeatureWritable(arg2.getFeatureType());
        fw.setFeature(arg2);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (DataOutputStream os = new DataOutputStream(bos);){
            fw.write((DataOutput)os);
            os.flush();
            byte[] data = bos.toByteArray();
            arg1.writeInt(data.length);
            arg1.write(data);
        }
        catch (IOException e) {
            LOGGER.error("Cannot serialize Simple Feature", (Throwable)e);
        }
    }
}

