/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.kmeans.serial;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.locationtech.geowave.analytic.AnalyticItemWrapper;
import org.locationtech.geowave.analytic.AnalyticItemWrapperFactory;
import org.locationtech.geowave.analytic.clustering.CentroidPairing;
import org.locationtech.geowave.analytic.kmeans.AssociationNotification;
import org.locationtech.geowave.analytic.kmeans.CentroidAssociationFn;
import org.locationtech.geowave.analytic.kmeans.serial.AnalyticStats;
import org.locationtech.geowave.analytic.kmeans.serial.StatsMap;
import org.locationtech.geowave.analytic.sample.SampleNotification;
import org.locationtech.geowave.analytic.sample.Sampler;

public class KMeansParallelInitialize<T> {
    private CentroidAssociationFn<T> centroidAssociationFn = new CentroidAssociationFn();
    private double psi = 5.0;
    private final Sampler<T> sampler = new Sampler();
    private AnalyticItemWrapperFactory<T> centroidFactory;
    private final AnalyticStats stats = new StatsMap();

    public CentroidAssociationFn<T> getCentroidAssociationFn() {
        return this.centroidAssociationFn;
    }

    public void setCentroidAssociationFn(CentroidAssociationFn<T> centroidAssociationFn) {
        this.centroidAssociationFn = centroidAssociationFn;
    }

    public double getPsi() {
        return this.psi;
    }

    public void setPsi(double psi) {
        this.psi = psi;
    }

    public Sampler<T> getSampler() {
        return this.sampler;
    }

    public AnalyticItemWrapperFactory<T> getCentroidFactory() {
        return this.centroidFactory;
    }

    public void setCentroidFactory(AnalyticItemWrapperFactory<T> centroidFactory) {
        this.centroidFactory = centroidFactory;
    }

    public AnalyticStats getStats() {
        return this.stats;
    }

    public Pair<List<CentroidPairing<T>>, List<AnalyticItemWrapper<T>>> runLocal(Iterable<AnalyticItemWrapper<T>> pointSet) {
        this.stats.reset();
        final ArrayList sampleSet = new ArrayList();
        sampleSet.add(pointSet.iterator().next());
        final ArrayList pairingSet = new ArrayList();
        AssociationNotification assocFn = new AssociationNotification<T>(){

            @Override
            public void notify(CentroidPairing<T> pairing) {
                pairingSet.add(pairing);
                pairing.getCentroid().incrementAssociationCount(1L);
            }
        };
        double normalizingConstant = this.centroidAssociationFn.compute(pointSet, sampleSet, assocFn);
        this.stats.notify(AnalyticStats.StatValue.COST, normalizingConstant);
        int logPsi = Math.max(1, (int)(Math.log(this.psi) / Math.log(2.0)));
        for (int i = 0; i < logPsi; ++i) {
            this.sampler.sample(pairingSet, new SampleNotification<T>(){

                @Override
                public void notify(T item, boolean partial) {
                    sampleSet.add(KMeansParallelInitialize.this.centroidFactory.create(item));
                }
            }, normalizingConstant);
            pairingSet.clear();
            for (AnalyticItemWrapper analyticItemWrapper : sampleSet) {
                analyticItemWrapper.resetAssociatonCount();
            }
            normalizingConstant = this.centroidAssociationFn.compute(pointSet, sampleSet, assocFn);
            this.stats.notify(AnalyticStats.StatValue.COST, normalizingConstant);
        }
        return Pair.of(pairingSet, sampleSet);
    }
}

