/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.kmeans;

import org.locationtech.geowave.analytic.AnalyticItemWrapper;
import org.locationtech.geowave.analytic.clustering.CentroidPairing;
import org.locationtech.geowave.analytic.distance.DistanceFn;
import org.locationtech.geowave.analytic.kmeans.AssociationNotification;

public class CentroidAssociationFn<T> {
    private DistanceFn<T> distanceFunction;

    public DistanceFn<T> getDistanceFunction() {
        return this.distanceFunction;
    }

    public void setDistanceFunction(DistanceFn<T> distanceFunction) {
        this.distanceFunction = distanceFunction;
    }

    public double compute(AnalyticItemWrapper<T> point, Iterable<AnalyticItemWrapper<T>> targetSet, AssociationNotification<T> associationNotification) {
        CentroidPairing<T> pairing = new CentroidPairing<T>(null, point, Double.POSITIVE_INFINITY);
        for (AnalyticItemWrapper<T> y : targetSet) {
            double distance = this.distanceFunction.measure(point.getWrappedItem(), y.getWrappedItem());
            if (!(distance < pairing.getDistance())) continue;
            pairing.setDistance(distance);
            pairing.setCentroid(y);
        }
        associationNotification.notify(pairing);
        return pairing.getDistance();
    }

    public double compute(Iterable<AnalyticItemWrapper<T>> pointSet, Iterable<AnalyticItemWrapper<T>> targetSet, AssociationNotification<T> associationNotification) {
        double sum = 0.0;
        for (AnalyticItemWrapper<T> point : pointSet) {
            sum += this.compute(point, targetSet, associationNotification);
        }
        return sum;
    }
}

