/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.extract;

import java.util.Calendar;
import java.util.Date;
import org.locationtech.geowave.analytic.extract.DimensionExtractor;
import org.locationtech.geowave.analytic.extract.SimpleFeatureGeometryExtractor;
import org.locationtech.geowave.core.geotime.util.TimeUtils;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.AttributeDescriptor;

public class TimeDimensionExtractor
extends SimpleFeatureGeometryExtractor
implements DimensionExtractor<SimpleFeature> {
    private static final long serialVersionUID = 1L;
    private static final String[] TIME_NAME = new String[]{"time"};

    @Override
    public double[] getDimensions(SimpleFeature anObject) {
        double[] timeVal = new double[1];
        double count = 0.0;
        for (AttributeDescriptor attr : anObject.getFeatureType().getAttributeDescriptors()) {
            if (!TimeUtils.isTemporal(attr.getType().getClass())) continue;
            Object o = anObject.getAttribute(attr.getName());
            count += 1.0;
            if (o instanceof Date) {
                timeVal[0] = timeVal[0] + (double)((Date)o).getTime();
                continue;
            }
            if (!(o instanceof Calendar)) continue;
            timeVal[0] = timeVal[0] + (double)((Calendar)o).getTime().getTime();
        }
        if (count > 0.0) {
            timeVal[0] = timeVal[0] / count;
        }
        return timeVal;
    }

    @Override
    public String[] getDimensionNames() {
        return TIME_NAME;
    }
}

