/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.distance;

import org.locationtech.geowave.analytic.distance.CoordinateEuclideanDistanceFn;
import org.locationtech.geowave.analytic.distance.DistanceFn;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;

public class GeometryCentroidDistanceFn
implements DistanceFn<Geometry> {
    private static final long serialVersionUID = -4340689267509659236L;
    private DistanceFn<Coordinate> coordinateDistanceFunction = new CoordinateEuclideanDistanceFn();

    public GeometryCentroidDistanceFn() {
    }

    public GeometryCentroidDistanceFn(DistanceFn<Coordinate> coordinateDistanceFunction) {
        this.coordinateDistanceFunction = coordinateDistanceFunction;
    }

    public DistanceFn<Coordinate> getCoordinateDistanceFunction() {
        return this.coordinateDistanceFunction;
    }

    public void setCoordinateDistanceFunction(DistanceFn<Coordinate> coordinateDistanceFunction) {
        this.coordinateDistanceFunction = coordinateDistanceFunction;
    }

    @Override
    public double measure(Geometry x, Geometry y) {
        return this.coordinateDistanceFunction.measure(x.getCentroid().getCoordinate(), y.getCentroid().getCoordinate());
    }
}

