/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.distance;

import org.locationtech.geowave.analytic.distance.CoordinateEuclideanDistanceFn;
import org.locationtech.geowave.analytic.distance.DistanceFn;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;

public class FeatureCentroidDistanceFn
implements DistanceFn<SimpleFeature> {
    private static final long serialVersionUID = 3824608959408031752L;
    private DistanceFn<Coordinate> coordinateDistanceFunction = new CoordinateEuclideanDistanceFn();

    public FeatureCentroidDistanceFn() {
    }

    public FeatureCentroidDistanceFn(DistanceFn<Coordinate> coordinateDistanceFunction) {
        this.coordinateDistanceFunction = coordinateDistanceFunction;
    }

    public DistanceFn<Coordinate> getCoordinateDistanceFunction() {
        return this.coordinateDistanceFunction;
    }

    public void setCoordinateDistanceFunction(DistanceFn<Coordinate> coordinateDistanceFunction) {
        this.coordinateDistanceFunction = coordinateDistanceFunction;
    }

    private Geometry getGeometry(SimpleFeature x) {
        for (Object attr : x.getAttributes()) {
            if (!(attr instanceof Geometry)) continue;
            return (Geometry)attr;
        }
        return (Geometry)x.getDefaultGeometry();
    }

    @Override
    public double measure(SimpleFeature x, SimpleFeature y) {
        return this.coordinateDistanceFunction.measure(this.getGeometry(x).getCentroid().getCoordinate(), this.getGeometry(y).getCentroid().getCoordinate());
    }
}

