/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.clustering;

import org.apache.commons.codec.binary.Hex;
import org.locationtech.geowave.core.index.ByteArray;

public class NeighborData<T>
implements Comparable<NeighborData<T>> {
    private T element;
    private ByteArray id;
    private double distance;

    public NeighborData() {
    }

    public NeighborData(T element, ByteArray id, double distance) {
        this.element = element;
        this.id = id;
        this.distance = distance;
    }

    public NeighborData(NeighborData<T> element, double distance) {
        this.element = element.getElement();
        this.id = element.getId();
        this.distance = distance;
    }

    public ByteArray getId() {
        return this.id;
    }

    protected void setId(ByteArray id) {
        this.id = id;
    }

    public double getDistance() {
        return this.distance;
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    public T getElement() {
        return this.element;
    }

    protected void setElement(T neighbor) {
        this.element = neighbor;
    }

    public int hashCode() {
        return this.element == null ? 0 : this.element.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NeighborData other = (NeighborData)obj;
        return !(this.element == null ? other.element != null : !this.element.equals(other.element));
    }

    @Override
    public int compareTo(NeighborData<T> otherNNData) {
        int dist = Double.compare(this.distance, otherNNData.distance);
        return dist == 0 ? this.hashCode() - otherNNData.hashCode() : dist;
    }

    public String toString() {
        return (this.id == null ? "" : Hex.encodeHexString((byte[])this.id.getBytes()) + ":") + this.element.toString() + "(" + this.distance + ")";
    }
}

