/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.clustering;

import java.io.IOException;
import org.apache.hadoop.mapreduce.JobContext;
import org.locationtech.geowave.analytic.AnalyticItemWrapper;
import org.locationtech.geowave.analytic.AnalyticItemWrapperFactory;
import org.locationtech.geowave.analytic.clustering.CentroidPairing;
import org.locationtech.geowave.analytic.clustering.NestedGroupCentroidAssignment;
import org.locationtech.geowave.analytic.kmeans.AssociationNotification;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CentroidItemWrapperFactory<T>
implements AnalyticItemWrapperFactory<T> {
    static final Logger LOGGER = LoggerFactory.getLogger(CentroidItemWrapperFactory.class);
    private AnalyticItemWrapperFactory<T> itemFactory;
    private NestedGroupCentroidAssignment<T> nestedGroupCentroidAssignment;

    @Override
    public AnalyticItemWrapper<T> create(T item) {
        return new CentroidItemWrapper(item);
    }

    @Override
    public void initialize(JobContext context, Class<?> scope, Logger logger) throws IOException {
        try {
            this.nestedGroupCentroidAssignment = new NestedGroupCentroidAssignment(context, scope, logger);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IOException("Failed to instantiate", e);
        }
        this.itemFactory.initialize(context, scope, logger);
    }

    public AnalyticItemWrapperFactory<T> getItemFactory() {
        return this.itemFactory;
    }

    public void setItemFactory(AnalyticItemWrapperFactory<T> itemFactory) {
        this.itemFactory = itemFactory;
    }

    @Override
    public AnalyticItemWrapper<T> createNextItem(T feature, String groupID, Coordinate coordinate, String[] extraNames, double[] extraValues) {
        return this.itemFactory.createNextItem(feature, groupID, coordinate, extraNames, extraValues);
    }

    public class CentroidItemWrapper
    implements AnalyticItemWrapper<T> {
        final AnalyticItemWrapper<T> wrappedItem;
        AnalyticItemWrapper<T> centroidItem;

        public CentroidItemWrapper(T item) {
            this.wrappedItem = CentroidItemWrapperFactory.this.itemFactory.create(item);
            try {
                CentroidItemWrapperFactory.this.nestedGroupCentroidAssignment.findCentroidForLevel(this.wrappedItem, new AssociationNotification<T>(){

                    @Override
                    public void notify(CentroidPairing<T> pairing) {
                        CentroidItemWrapper.this.centroidItem = pairing.getCentroid();
                    }
                });
            }
            catch (IOException e) {
                LOGGER.error("Cannot resolve paired centroid for " + this.wrappedItem.getID(), (Throwable)e);
                this.centroidItem = this.wrappedItem;
            }
        }

        @Override
        public String getID() {
            return this.centroidItem.getID();
        }

        @Override
        public T getWrappedItem() {
            return this.centroidItem.getWrappedItem();
        }

        @Override
        public long getAssociationCount() {
            return this.centroidItem.getAssociationCount();
        }

        @Override
        public int getIterationID() {
            return this.centroidItem.getIterationID();
        }

        @Override
        public String getGroupID() {
            return this.centroidItem.getID();
        }

        @Override
        public void setGroupID(String groupID) {
        }

        @Override
        public void resetAssociatonCount() {
        }

        @Override
        public void incrementAssociationCount(long increment) {
        }

        @Override
        public double getCost() {
            return this.centroidItem.getCost();
        }

        @Override
        public void setCost(double cost) {
        }

        @Override
        public String getName() {
            return this.centroidItem.getName();
        }

        @Override
        public String[] getExtraDimensions() {
            return new String[0];
        }

        @Override
        public double[] getDimensionValues() {
            return new double[0];
        }

        @Override
        public Geometry getGeometry() {
            return this.centroidItem.getGeometry();
        }

        @Override
        public void setZoomLevel(int level) {
        }

        @Override
        public int getZoomLevel() {
            return this.centroidItem.getZoomLevel();
        }

        @Override
        public void setBatchID(String batchID) {
        }

        @Override
        public String getBatchID() {
            return this.centroidItem.getBatchID();
        }
    }
}

