/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShapefileTool {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShapefileTool.class);

    private static SimpleFeatureType createFeatureType(String typeName, boolean isPoint) {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(typeName);
        builder.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        builder.add("the_geom", isPoint ? Point.class : Polygon.class);
        builder.length(15).add("Name", String.class);
        return builder.buildFeatureType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"}, justification="Directories may alreadybe there")
    public static void writeShape(String typeName, File dir, Geometry[] shapes) throws IOException {
        FileUtils.deleteDirectory((File)dir);
        dir.mkdirs();
        SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(ShapefileTool.createFeatureType(typeName, shapes[0] instanceof Point));
        ShapefileDataStoreFactory dataStoreFactory = new ShapefileDataStoreFactory();
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put("url", new File(dir.getAbsolutePath() + "/" + typeName + ".shp").toURI().toURL());
        params.put("create spatial index", Boolean.TRUE);
        ShapefileDataStore newDataStore = (ShapefileDataStore)dataStoreFactory.createNewDataStore(params);
        newDataStore.createSchema(ShapefileTool.createFeatureType(typeName, shapes[0] instanceof Point));
        DefaultTransaction transaction = new DefaultTransaction("create");
        try (FeatureWriter writer = newDataStore.getFeatureWriterAppend(typeName, (Transaction)transaction);){
            boolean i = true;
            for (Geometry shape : shapes) {
                featureBuilder.add((Object)shape);
                featureBuilder.add((Object)1);
                SimpleFeature feature = featureBuilder.buildFeature(null);
                SimpleFeature copy = (SimpleFeature)writer.next();
                for (AttributeDescriptor attrD : feature.getFeatureType().getAttributeDescriptors()) {
                    if (copy.getFeatureType().getDescriptor(attrD.getName()) == null) continue;
                    copy.setAttribute(attrD.getName(), feature.getAttribute(attrD.getName()));
                }
                copy.setDefaultGeometry(feature.getDefaultGeometry());
                writer.write();
            }
        }
        catch (IOException e) {
            LOGGER.warn("Problem with the FeatureWritter", (Throwable)e);
            transaction.rollback();
        }
        finally {
            transaction.commit();
            transaction.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"}, justification="Directories may alreadybe there")
    public static void writeShape(File dir, List<SimpleFeature> shapes) throws IOException {
        FileUtils.deleteDirectory((File)dir);
        dir.mkdirs();
        ShapefileDataStoreFactory dataStoreFactory = new ShapefileDataStoreFactory();
        String typeName = shapes.get(0).getType().getTypeName();
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put("url", new File(dir.getAbsolutePath() + "/" + typeName + ".shp").toURI().toURL());
        params.put("create spatial index", Boolean.TRUE);
        ShapefileDataStore newDataStore = (ShapefileDataStore)dataStoreFactory.createNewDataStore(params);
        newDataStore.createSchema(shapes.get(0).getFeatureType());
        DefaultTransaction transaction = new DefaultTransaction("create");
        try (FeatureWriter writer = newDataStore.getFeatureWriterAppend(typeName, (Transaction)transaction);){
            for (SimpleFeature shape : shapes) {
                SimpleFeature copy = (SimpleFeature)writer.next();
                for (AttributeDescriptor attrD : copy.getFeatureType().getAttributeDescriptors()) {
                    if (copy.getFeatureType().getDescriptor(attrD.getName()) == null) continue;
                    copy.setAttribute(attrD.getName(), shape.getAttribute(attrD.getName()));
                }
                copy.setDefaultGeometry(shape.getDefaultGeometry());
                writer.write();
            }
        }
        catch (IOException e) {
            LOGGER.warn("Problem with the FeatureWritter", (Throwable)e);
            transaction.rollback();
        }
        finally {
            transaction.commit();
            transaction.close();
        }
    }
}

