/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic;

import org.apache.hadoop.conf.Configuration;
import org.locationtech.geowave.core.index.ByteArrayUtils;
import org.locationtech.geowave.mapreduce.GeoWaveConfiguratorBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScopedJobConfiguration {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ScopedJobConfiguration.class);
    private final Configuration jobConfiguration;
    private final Class<?> scope;
    private Logger logger = LOGGER;

    public ScopedJobConfiguration(Configuration jobConfiguration, Class<?> scope) {
        this.jobConfiguration = jobConfiguration;
        this.scope = scope;
    }

    public ScopedJobConfiguration(Configuration jobConfiguration, Class<?> scope, Logger logger) {
        this.jobConfiguration = jobConfiguration;
        this.scope = scope;
        this.logger = logger;
    }

    public int getInt(Enum<?> property, int defaultValue) {
        String propName = GeoWaveConfiguratorBase.enumToConfKey(this.scope, property);
        if (this.jobConfiguration.getRaw(propName) == null) {
            this.logger.warn("Using default for property " + propName);
        }
        int v = this.jobConfiguration.getInt(propName, defaultValue);
        return v;
    }

    public String getString(Enum<?> property, String defaultValue) {
        String propName = GeoWaveConfiguratorBase.enumToConfKey(this.scope, property);
        if (this.jobConfiguration.getRaw(propName) == null) {
            this.logger.warn("Using default for property " + propName);
        }
        return this.jobConfiguration.get(propName, defaultValue);
    }

    public <T> T getInstance(Enum<?> property, Class<T> iface, Class<? extends T> defaultValue) throws InstantiationException, IllegalAccessException {
        try {
            String propName = GeoWaveConfiguratorBase.enumToConfKey(this.scope, property);
            if (this.jobConfiguration.getRaw(propName) == null) {
                if (defaultValue == null) {
                    return null;
                }
                this.logger.warn("Using default for property " + propName);
            }
            return this.jobConfiguration.getClass(GeoWaveConfiguratorBase.enumToConfKey(this.scope, property), defaultValue, iface).newInstance();
        }
        catch (Exception ex) {
            this.logger.error("Cannot instantiate " + GeoWaveConfiguratorBase.enumToConfKey(this.scope, property));
            throw ex;
        }
    }

    public double getDouble(Enum<?> property, double defaultValue) {
        String propName = GeoWaveConfiguratorBase.enumToConfKey(this.scope, property);
        if (this.jobConfiguration.getRaw(propName) == null) {
            this.logger.warn("Using default for property " + propName);
        }
        return this.jobConfiguration.getDouble(propName, defaultValue);
    }

    public byte[] getBytes(Enum<?> property) {
        String propName = GeoWaveConfiguratorBase.enumToConfKey(this.scope, property);
        String data = this.jobConfiguration.getRaw(propName);
        if (data == null) {
            this.logger.error(propName + " not found ");
        }
        return ByteArrayUtils.byteArrayFromString((String)data);
    }
}

