/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic;

import java.nio.ByteBuffer;
import org.locationtech.geowave.core.index.VarintUtils;
import org.locationtech.geowave.core.index.persist.Persistable;

public class GeoObjectDimensionValues
implements Persistable {
    public double x = 0.0;
    public double y = 0.0;
    public double z = 0.0;
    public double[] values = new double[0];
    public double distance = 0.0;
    public long count = 0L;

    public GeoObjectDimensionValues(int extraValuesCount) {
        this.values = new double[extraValuesCount];
    }

    public GeoObjectDimensionValues() {
    }

    public GeoObjectDimensionValues(double x, double y, double z, double[] extraDimensions, double distance) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.values = extraDimensions;
        this.distance = distance;
        this.count = 1L;
    }

    public void add(GeoObjectDimensionValues association) {
        this.x += association.x;
        this.y += association.y;
        this.z += association.z;
        for (int i = 0; i < this.values.length; ++i) {
            int n = i;
            this.values[n] = this.values[n] + association.values[i];
        }
        this.distance += association.distance;
        this.count += association.count;
    }

    public void set(double x, double y, double z, double[] extraDimensions, double distance) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.values = extraDimensions;
        this.distance = distance;
        this.count = 1L;
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getZ() {
        return this.z;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public double getDistance() {
        return this.distance;
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    public byte[] toBinary() {
        ByteBuffer b = ByteBuffer.allocate((4 + this.values.length) * 8 + VarintUtils.unsignedIntByteLength((int)this.values.length) + VarintUtils.unsignedLongByteLength((long)this.count));
        VarintUtils.writeUnsignedLong((long)this.count, (ByteBuffer)b);
        b.putDouble(this.x);
        b.putDouble(this.y);
        b.putDouble(this.z);
        b.putDouble(this.distance);
        VarintUtils.writeUnsignedInt((int)this.values.length, (ByteBuffer)b);
        for (double value : this.values) {
            b.putDouble(value);
        }
        return b.array();
    }

    public void fromBinary(byte[] bytes) {
        int i;
        ByteBuffer b = ByteBuffer.wrap(bytes);
        this.count = VarintUtils.readUnsignedLong((ByteBuffer)b);
        this.x = b.getDouble();
        this.y = b.getDouble();
        this.z = b.getDouble();
        this.distance = b.getDouble();
        this.values = new double[i];
        for (i = VarintUtils.readUnsignedInt((ByteBuffer)b); i > 0; --i) {
            this.values[i - 1] = b.getDouble();
        }
    }
}

